# coding: utf-8

from __future__ import absolute_import

from sandbox import sdk2


class ANIMALS_VM(sdk2.resource.AbstractResource):
    """Virtual machines images used in Animals project
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_IAM_DOCKER_IMAGE(sdk2.resource.AbstractResource):
    """Docker image for Animals authorization server
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_IAM_JWKS(sdk2.resource.AbstractResource):
    """JSON Web Key Set and key id for Animals authorization server
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_IAM_JWKS_TESTING(sdk2.resource.AbstractResource):
    """JSON Web Key Set and key id for Animals authorization server (testing)
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_ADMIN_CRT_DOCKER_IMAGE(sdk2.resource.AbstractResource):
    """Docker image for Animals administration API adapter to Certificator API
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_ASSESSOR_DOCUMENTS(sdk2.resource.AbstractResource):
    """Document templates for assessors
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_HTTP_TEMPORAL_GATEWAY_DOCKER_IMAGE(sdk2.resource.AbstractResource):
    """Docker image for gateway from HTTP requests to Temporal workflows
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_ASSESSOR_WORKFLOW_DOCKER_IMAGE(sdk2.resource.AbstractResource):
    """Docker image for assessors workflow worker
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_ASSESSOR_WORKFLOW_DOCUMENTS(sdk2.resource.AbstractResource):
    """Documents for assessor used in corresponding workflow
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_HOMER_SH(sdk2.resource.AbstractResource):
    """Script to manage homer
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_HOMER_PRESEED(sdk2.resource.AbstractResource):
    """Homer installation preseed files and install scripts
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_GOXCART_DOCKER_IMAGE(sdk2.resource.AbstractResource):
    """Special resource to release Docker image for Goxcart with Animals config
    """

    auto_backup = True
    releasable = True
    releasers = [
        "aduryagin", "robot-animals", "robot-srch-releaser", "ANIMALS",
    ]


class ANIMALS_FRONTEND_STATIC_ASSETS(sdk2.resource.AbstractResource):
    """Dependencies for Animals user frontend
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]


class ANIMALS_CI_LAYER(sdk2.resource.AbstractResource):
    """Layer to use in CI build tasks
    """

    auto_backup = True
    releasable = True
    releasers = ["aduryagin", "robot-animals", "ANIMALS"]
