# -*- coding: utf-8 -*-
import time

from gspread import service_account
from yql.api.v1.client import YqlClient
from yt.wrapper import YtClient

# Without this block gspread doesn't work on python 2
import sys
reload(sys)
sys.setdefaultencoding('utf-8')


YT_CLUSTER = 'arnold'
TABLE_PATH = '//home/answers/zmiecer/ANSWERS-12883/communities-export'
# prod table: https://docs.google.com/spreadsheets/d/1DGmCofgmM6DWF1pLSmuBTM1tRS0fFC1dRr-4QIAd8ik/edit?usp=sharing
SHEET_ID = '1DGmCofgmM6DWF1pLSmuBTM1tRS0fFC1dRr-4QIAd8ik'


def run_yql_query(yql_query, yt_cluster, yql_token):
    with YqlClient(db=yt_cluster, token=yql_token) as yql_client:
        for i in range(5):
            request = yql_client.query(yql_query, title='Automated YQL Q toxic commentators export for ANSWERS-13015')
            request.run()
            if request.get_results().status == 'COMPLETED':
                break
        else:
            raise Exception("YQL query can't succeed")


def export_info_to_spreadsheet(table_path, sheet_id, yt_cluster, yql_token):
    google_client = service_account('google_api_key.json')
    sheet = google_client.open_by_key(sheet_id)
    worksheet = sheet.get_worksheet(0)

    links = set(worksheet.col_values(1)[1:])
    yt_client = YtClient(proxy=yt_cluster, token=yql_token)

    for row in yt_client.read_table(table_path):
        url = row['url']
        if url in links:
            continue
        line = [row['url'], row['created'], row['title'], row['description'], row['tags'], row['links']]
        worksheet.append_row(line, table_range='A1')
        time.sleep(10)

    worksheet = sheet.get_worksheet(0)
    worksheet.sort((2, 'des'), range='A2:Z{}'.format(worksheet.row_count))


if __name__ == '__main__':
    sys.stdout.write('Importing YQL token\n')
    with open('YQL_TOKEN', mode='r') as token_file:
        yql_token = token_file.readline().strip()

    sys.stdout.write('Starting YQL Query\n')
    with open('query.yql') as yql_query_file:
        yql_query = yql_query_file.read().strip()
    run_yql_query(yql_query, YT_CLUSTER, yql_token)

    sys.stdout.write('YQL Query finished. Starting export to Google Sheets\n')
    export_info_to_spreadsheet(TABLE_PATH, SHEET_ID, YT_CLUSTER, yql_token)

    sys.stdout.write('Export finished\n')
