# -*- coding: utf-8 -*-

import logging
import sandbox.common.types.resource as ctr
from sandbox import sdk2
from sandbox.sdk2 import parameters
from sandbox.projects.answers import resources
from sandbox.projects.answers.AnswersDumpToYt import AnswersDumpToYt


class AnswersDumpTheQuestionToYt(AnswersDumpToYt):

    skip_tables = {}

    class Parameters(sdk2.Parameters):
        use_last_dump = parameters.Bool(
            'Use last database dump to copy on YT',
            required=True,
            default=True,
        )
        with use_last_dump.value[False]:
            psql_dump = parameters.Resource(
                'Dump of Answers PSQL',
                resource_type=resources.AnswersTheQuestionPostgresqlDump,
                required=True,
            )
        postgres_resource = parameters.Resource(
            'Resource with PSQL',
            resource_type=resources.AnswersPostgresql,
            required=True,
        )
        ramdrive_size = parameters.Integer('RamDrive size in GB', default=4)
        yt_base_directory = parameters.String(
            'Yt base directory',
            required=True,
        )
        yt_proxy = parameters.String(
            'Yt proxy',
            required=True,
            default='banach',
        )
        yt_token = parameters.String(
            'Answers Yt Token Secret',
            required=True,
        )
        gpg_key_owner = parameters.String(
            'Gpg Key Owner',
            required=True,
        )
        env = parameters.String(
            'Database environment',
            choices=[
                ('dev', resources.Environments.DEV),
                ('prod', resources.Environments.PROD),
                ('prestable', resources.Environments.PRESTABLE),
            ],
            required=True,
        )
        left_only_n_snapshots = parameters.Integer(
            'Left only N snapshots, remove rest (0 = unlimited)',
            default=0
        )

    def get_encrypted_dump_path(self):
        if not self.Parameters.use_last_dump:
            result = str(
                sdk2.ResourceData(
                    sdk2.Resource[self.Parameters.psql_dump]
                ).path
            )
        else:
            dump_resource = sdk2.Resource.find(
                resources.AnswersTheQuestionPostgresqlDump,
                attrs={'env': self.Parameters.env},
                state=ctr.State.READY,
            ).order(
                -resources.AnswersTheQuestionPostgresqlDump.id,
            ).first()
            result = str(sdk2.ResourceData(dump_resource).path)
        logging.info('Using dump resource: %s', result)
        return result
