from sandbox import sdk2

from sandbox.projects.answers.AnswersFrontendBase import resources


class AnswersFrontendBase(object):
    @property
    def production_resource(self):
        return resources.AnswersFrontendResourcePackage

    @property
    def testing_resource(self):
        return resources.AnswersFrontendResourceTestPackage

    @property
    def size_resource(self):
        return resources.AnswersFrontendResourceSize

    @property
    def static_resource(self):
        return resources.AnswersFrontendResourceStatic

    def checkout(self):
        with sdk2.ssh.Key(self, 'ANSWERS', 'assessors_bb_ssh'):
            self.checkout_without_cache()
