from sandbox import sdk2
from sandbox.projects.answers import AnswersResourceBase


class AnswersFrontendResourceBase(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersFrontendResourcePackage(AnswersFrontendResourceBase):
    """
        Answers frontend package
    """


class AnswersFrontendResourceTestPackage(AnswersFrontendResourceBase):
    """
        Answers test frontend package
    """


class AnswersFrontendResourceStatic(AnswersFrontendResourceBase):
    """
        Answers frontend static
    """
    env = sdk2.parameters.String('Environment')
    version = sdk2.parameters.String('Version')


class AnswersFrontendResourceSize(AnswersFrontendResourceBase):
    """
        Answers frontend size
    """
    env = sdk2.parameters.String('Environment')
    target = sdk2.parameters.String('Target')


class AnswersFrontendHermioneCoverage(AnswersFrontendResourceBase):
    """
        Answers frontend hermione coverage
    """
    env = sdk2.parameters.String('Environment')


class AnswersFrontendResourcePulse(AnswersFrontendResourceBase):
    """
        Answers JSON pulse
    """
    stand = sdk2.parameters.String('Stand')
