# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sdk2 import parameters
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.answers import resources
from sandbox.projects.answers.common.encrypt_mixin import EncryptMixin


class AnswersPopulateTurbo(sdk2.Task, EncryptMixin):

    class Requirements(sdk2.Task.Requirements):
        environments = (
            PipEnvironment('yandex-yt'),
            PipEnvironment("yandex-yt-yson-bindings-skynet"),
            PipEnvironment('retry'),
        )

    class Parameters(sdk2.Parameters):

        yt_input_db = parameters.String(
            'Yt input database',
            required=True,
            default='//home/answers/dshmatkov/2018-01-10T12:37:10.441649/'
        )

        yt_output_db = parameters.String(
            'Yt output database',
            required=True,
            default='//home/answers/kasperovich/turbo2018-01-10T12:37:10.441649/'
        )

        yt_proxy = parameters.String(
            'Yt proxy',
            required=True,
            default='banach',
        )

        yt_token = parameters.String(
            'Answers yt token',
            required=True,
        )

        binary_resource = parameters.Resource(
            'Runs yt commands answers database and produces database for turbo',
            resource_type=resources.AnswersExporter,
            required=False,
        )

    def on_execute(self):

        logging.info('Exporting answers has started.')

        local_executable_path = str(sdk2.ResourceData(sdk2.Resource[self.Parameters.binary_resource]).path)

        logging.info('Loaded binary resource at local path: ' + local_executable_path)

        yt_token = sdk2.Vault.data(self.Parameters.yt_token)

        cmd_parameters = '--server={} --input-db={} --output-db={} --yt-token={}'.format(
            self.Parameters.yt_proxy,
            self.Parameters.yt_input_db,
            self.Parameters.yt_output_db,
            yt_token
        )

        logging.info('Prepared command line parameters: ' + cmd_parameters)

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('debug_log')) as pl:
            subprocess.Popen(local_executable_path + ' ' + cmd_parameters,
                             shell=True, stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

        logging.info('Exporting answers is finished.')
