import os
import subprocess

from sandbox import sdk2
from shutil import copyfile


class AnswersToxicCommentatorsExport(sdk2.Task):
    def on_execute(self):
        yql_token = sdk2.Vault.data('answers_robot_yql_token')
        google_api_key = sdk2.Vault.data('zmiecer', 'google_api_key')

        src_dir = os.path.dirname(os.path.realpath(__file__))
        req_path = os.path.join(src_dir, 'requirements.txt')
        script_path = os.path.join(src_dir, 'script.py')
        query_path = os.path.join(src_dir, 'query.yql')
        copyfile(query_path, './query.yql')

        with open('YQL_TOKEN', mode='w') as token_file:
            token_file.write(yql_token)

        with open('google_api_key.json', mode='w') as google_api_key_file:
            google_api_key_file.write(google_api_key)

        with sdk2.environments.VirtualEnvironment() as venv:
            venv.pip("pip==19.1 setuptools==41.0.1")
            venv.pip("-r {} --ignore-installed".format(req_path))
            with sdk2.helpers.ProcessLog(self, logger="script-log") as pl:
                subprocess.check_call([venv.executable, script_path], stdout=pl.stdout, stderr=pl.stdout)
