# -*- coding: utf-8 -*-
import time

from gspread import service_account
from yql.api.v1.client import YqlClient
from yt.wrapper import YtClient

# Without this block gspread doesn't work on python 2
import sys
reload(sys)
sys.setdefaultencoding('utf-8')


YT_CLUSTER = 'arnold'
YT_DIR_PATH = '//home/answers/zmiecer/ANSWERS-13131'
YT_ALL_TABLE_PATH = YT_DIR_PATH + '/vaccination-all-export'
YT_COMMUNITY_TABLE_PATH = YT_DIR_PATH + '/vaccination-community-export'
# prod table: https://docs.google.com/spreadsheets/d/1C9LOCi110sCxgisuIFWJBDx0zO6dAxwuT9dtts-G48E/edit?usp=sharing
GOOGLE_SHEET_ID = '1C9LOCi110sCxgisuIFWJBDx0zO6dAxwuT9dtts-G48E'


def run_yql_query(yql_query, yt_cluster, yql_token):
    with YqlClient(db=yt_cluster, token=yql_token) as yql_client:
        for i in range(5):
            request = yql_client.query(yql_query, title='Automated Q vaccination export for ANSWERS-13015 [YQL]')
            request.run()
            if request.get_results().status == 'COMPLETED':
                break
        else:
            raise Exception('YQL query cannot succeed')


def export_info_to_spreadsheet(yt_table_path, sheet_id, worksheet_id, yt_client):
    google_client = service_account('google_api_key.json')
    sheet = google_client.open_by_key(sheet_id)

    worksheet = sheet.get_worksheet(worksheet_id)
    kinds_and_ids = set([x + '_' + y for x, y in zip(worksheet.col_values(3)[1:], worksheet.col_values(2)[1:])])
    for row in yt_client.read_table(yt_table_path):
        kind_and_id = row['kind'] + '_' + row['id']
        if kind_and_id in kinds_and_ids:
            continue
        line = [row['created'], row['id'], row['kind'], row['user_link'], row['link'], row['title']]
        worksheet.append_row(line, table_range='A1')
        time.sleep(2)

    worksheet = sheet.get_worksheet(worksheet_id)
    worksheet.sort((1, 'des'), range='A2:Z{}'.format(worksheet.row_count))


if __name__ == '__main__':
    sys.stdout.write('Importing YQL token\n')
    with open('YQL_TOKEN', mode='r') as token_file:
        yql_token = token_file.readline().strip()

    sys.stdout.write('Starting YQL queries\n')
    with open('query.yql', mode='r') as yql_query_file:
        yql_query = yql_query_file.read().strip()
    run_yql_query(yql_query, YT_CLUSTER, yql_token)
    with open('query_2.yql', mode='r') as yql_query_file:
        yql_query_2 = yql_query_file.read().strip()
    run_yql_query(yql_query_2, YT_CLUSTER, yql_token)

    sys.stdout.write('YQL queries finished. Starting export to Google Sheets\n')
    yt_client = YtClient(proxy=YT_CLUSTER, token=yql_token)
    export_info_to_spreadsheet(YT_ALL_TABLE_PATH, GOOGLE_SHEET_ID, 0, yt_client)
    export_info_to_spreadsheet(YT_COMMUNITY_TABLE_PATH, GOOGLE_SHEET_ID, 1, yt_client)
    yt_client.remove(YT_DIR_PATH, recursive=True)

    sys.stdout.write('Export finished\n')
