# -*- coding: utf-8 -*-

from sandbox.projects.answers import resources
from sandbox.projects.common.build import YaMake, parameters as build_parameters
from sandbox.projects.common.nanny import nanny


class UseFuse(build_parameters.UseArcadiaApiFuse):
    default_value = True


class UseArc(build_parameters.UseArcInsteadOfArcadiaApi):
    default_value = True


class BuildAnswersBackend(YaMake.YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Сборка бандла бинарей бекенда Яндекс.Знатоков
    """
    type = 'BUILD_ANSWERS_BACKEND'

    execution_space = 140000

    input_parameters = [
        build_parameters.ArcadiaUrl,
        build_parameters.ClearBuild,
        UseFuse,
        UseArc,
    ]

    def get_context_override(self):
        return {
            build_parameters.CheckoutParameter.name: True,
            build_parameters.ForceVCSInfoUpdate.name: True,
        }

    def get_targets(self):
        return [
            # 'contrib/python/celery/py2/bin',
            'yweb/yasap/answers/database_migrations',
            'yweb/yasap/answers',
            'yweb/yasap/answers/worker',
            'yweb/yasap/answers/celery_beat',
            'yweb/yasap/answers/admin',
            'yweb/yasap/znatoki/the_question_downloader/bin',
            'yweb/yasap/znatoki/thequestion/bin',
            'yweb/yasap/answers/answers_yasm/bin',
            'yweb/yasap/answers/answers_fast/bin',
            'yweb/yasap/answers/blackbox_proxy/bin',
        ]

    def get_arts(self):
        return [
            # {'path': 'contrib/python/celery/py2/bin/celery'},
            {'path': 'yweb/yasap/answers/database_migrations/database_migrator'},
            {'path': 'yweb/yasap/answers/server'},
            {'path': 'yweb/yasap/answers/worker/worker'},
            {'path': 'yweb/yasap/answers/celery_beat/celery_beat'},
            {'path': 'yweb/yasap/answers/admin/server_admin'},
            {'path': 'yweb/yasap/znatoki/the_question_downloader/bin/the_question_downloader'},
            {'path': 'yweb/yasap/znatoki/thequestion/bin/thequestion'},
            {'path': 'yweb/yasap/answers/answers_yasm/bin/answers_yasm'},
            {'path': 'yweb/yasap/answers/answers_fast/bin/answers_fast'},
            {'path': 'yweb/yasap/answers/blackbox_proxy/bin/blackbox_proxy'},
        ]

    def get_resources(self):
        return {
            # 'celery': {
            #     'resource_type': resources.CeleryBinary,
            #     'description': 'Celery binary',
            #     'resource_path': 'celery',
            # },
            'database_migrator': {
                'resource_type': resources.AnswersDatabaseMigrator,
                'description': 'Answers database migrator',
                'resource_path': 'database_migrator',
            },
            'server': {
                'resource_type': resources.AnswersBackendServer,
                'description': 'Answers backend server',
                'resource_path': 'server',
            },
            'worker': {
                'resource_type': resources.AnswersBackendCeleryWorker,
                'description': 'Answers backend celery worker',
                'resource_path': 'worker',
            },
            'celery_beat': {
                'resource_type': resources.AnswersBackendCeleryBeat,
                'description': 'Answers backend celery beat',
                'resource_path': 'celery_beat',
            },
            'admin': {
                'resource_type': resources.AnswersBackendAdminServer,
                'description': 'Answers admin backend',
                'resource_path': 'server_admin',
            },
            'the_question_downloader': {
                'resource_type': resources.AnswersTheQuestionDownloadServer,
                'description': 'Answers the question upload server',
                'resource_path': 'the_question_downloader',
            },
            'the_question_server': {
                'resource_type': resources.AnswersTheQuestionServer,
                'description': 'Answers the question substitution server',
                'resource_path': 'thequestion',
            },
            'answers_yasm': {
                'resource_type': resources.AnswersBackendYasm,
                'description': 'Answers yasm metrics collector',
                'resource_path': 'answers_yasm',
            },
            'answers_fast': {
                'resource_type': resources.AnswersBackendHistory,
                'description': 'Answers history',
                'resource_path': 'answers_fast',
            },
            'blackbox_proxy': {
                'resource_type': resources.AnswersBlackboxProxy,
                'description': 'Blackbox proxy for l7 display_names',
                'resource_path': 'blackbox_proxy',
            },
        }

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMake.YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildAnswersBackend
