# -*- coding: utf-8 -*-

from sandbox.projects.answers import resources
from sandbox.projects.common.build import YaMake, parameters as build_parameters
from sandbox.projects.common.nanny import nanny


class UseFuse(build_parameters.UseArcadiaApiFuse):
    default_value = True


class UseArc(build_parameters.UseArcInsteadOfArcadiaApi):
    default_value = True


class BuildAnswersBackendTest(YaMake.YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Сборка бандла бинарей бекенда Яндекс.Знатоков
    """
    type = 'BUILD_ANSWERS_BACKEND_TEST'

    input_parameters = [
        build_parameters.ArcadiaUrl,
        build_parameters.ClearBuild,
        UseFuse,
        UseArc,
    ]

    def get_context_override(self):
        return {
            build_parameters.CheckoutParameter.name: True,
        }

    def get_targets(self):
        return [
            'contrib/python/celery/py2/bin',

            'yweb/yasap/answers/database_migrations',
            'yweb/yasap/answers',
            'yweb/yasap/answers/worker',
            'yweb/yasap/answers/admin',
            'yweb/yasap/znatoki/the_question_downloader/bin',
            'yweb/yasap/znatoki/thequestion/bin',
        ]

    def get_arts(self):
        return [
            {'path': 'contrib/python/celery/py2/bin/celery'},
            {'path': 'yweb/yasap/answers/database_migrations/database_migrator'},
            {'path': 'yweb/yasap/answers/server'},
            {'path': 'yweb/yasap/answers/worker/worker'},
            {'path': 'yweb/yasap/answers_admin/server_admin'},
            {'path': 'yweb/yasap/znatoki/the_question_downloader/bin/the_question_downloader'},
            {'path': 'yweb/yasap/znatoki/thequestion/bin/thequestion'},
        ]

    def get_resources(self):
        return {
            'celery': {
                'resource_type': resources.CeleryBinary,
                'description': 'Celery binary',
                'resource_path': 'celery',
            },

            'database_migrator': {
                'resource_type': resources.AnswersDatabaseMigrator,
                'description': 'Answers database migrator',
                'resource_path': 'database_migrator',
            },
            'server': {
                'resource_type': resources.AnswersBackendServer,
                'description': 'Answers backend server',
                'resource_path': 'server',
            },
            'worker': {
                'resource_type': resources.AnswersBackendCeleryWorker,
                'description': 'Answers backend celery worker',
                'resource_path': 'worker',
            },
            'admin': {
                'resource_type': resources.AnswersBackendAdminServer,
                'description': 'Answers admin backend',
                'resource_path': 'server_admin',
            },
            'the_question_downloader': {
                'resource_type': resources.AnswersTheQuestionDownloadServer,
                'description': 'Answers the question upload server',
                'resource_path': 'the_question_downloader',
            },
            'the_question_server': {
                'resource_type': resources.AnswersTheQuestionServer,
                'description': 'Answers the question substitution server',
                'resource_path': 'thequestion',
            },
        }

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMake.YaMakeTask.on_release(self, additional_parameters)


__Task__ = BuildAnswersBackendTest
