# -*- coding: utf-8 -*-

from sandbox.projects.answers import resources
from sandbox.projects.common.build import YaMake, parameters as build_parameters


class UseFuse(build_parameters.UseArcadiaApiFuse):
    default_value = True


class UseArc(build_parameters.UseArcInsteadOfArcadiaApi):
    default_value = True


class BuildAnswersCtl(YaMake.YaMakeTask):
    """
        Сборка бинаря ztk_ctl - command line tools
    """
    type = 'BUILD_ANSWERS_CTL'

    input_parameters = [
        build_parameters.ArcadiaUrl,
        build_parameters.ClearBuild,
        UseFuse,
        UseArc,
    ]

    def get_context_override(self):
        return {
            build_parameters.CheckoutParameter.name: True,
        }

    def get_targets(self):
        return [
            'yweb/yasap/znatoki/znatoki_ctl/bin',
        ]

    def get_arts(self):
        return [
            {'path': 'yweb/yasap/znatoki/znatoki_ctl/bin/ztkctl'},
        ]

    def get_resources(self):
        return {
            'ctl': {
                'resource_type': resources.AnswersCtl,
                'description': 'Answers Ctl',
                'resource_path': 'ztkctl',
            },
        }


__Task__ = BuildAnswersCtl
