# coding: utf-8

from sandbox import common
import os
from sandbox import sdk2

from sandbox.projects.answers import resources
from sandbox.sandboxsdk import paths
from sandbox.sdk2.helpers import subprocess as sp


class BuildAnswersFeedReaderData(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        index_builder_res = sdk2.parameters.Resource(
            "Index builder binary",
            resource_type=resources.AnswersFeedReaderIndexBuilder,
            required=True
        )
        yt_proxy = sdk2.parameters.String('YT proxy', required=True, default='banach')
        yt_token_vault = sdk2.parameters.String('YT token vault', required=True)
        yt_dumps_dir = sdk2.parameters.String("YT dump dir", required=True)
        yt_state_dir = sdk2.parameters.String("YT index state dir", required=True)

    def on_execute(self):
        index_builder_path = str(sdk2.ResourceData(self.Parameters.index_builder_res).path)

        shard_dir = self.path("shard")
        if os.path.exists(str(shard_dir)):
            paths.remove_path(shard_dir)
        paths.make_folder(shard_dir, True)

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.Parameters.yt_token_vault)

        with sdk2.helpers.ProcessLog(self, logger="index_builder_log") as pl:
            ret_code = sp.Popen(
                [
                    index_builder_path + "/index_builder/answers_index_builder",
                    "--server", self.Parameters.yt_proxy,
                    "--dump_dir", self.Parameters.yt_dumps_dir,
                    "--state_dir", self.Parameters.yt_state_dir,
                    "--output_dir", str(shard_dir)
                ],
                stdout=pl.stdout, stderr=sp.STDOUT, env=env
            ).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure('index_builder run failed')

        shard_archive_name = "shard.tar.gz"
        with sdk2.helpers.ProcessLog(self, logger="pack_to_tar_gz") as pl:
            sp.Popen(
                [
                    "tar",
                    "-czvf",
                    shard_archive_name,
                    "-C",
                    str(shard_dir),
                    "."
                ],
                stdout=pl.stdout, stderr=sp.STDOUT
            ).wait()

        sdk2.ResourceData(resources.AnswersFeedReaderData(
            self, "Feed reader index data", shard_archive_name
        )).ready()
