# -*- coding: utf-8 -*-

from sandbox.projects.answers import resources
from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny


class BuildAnswersRecommenderBinaries(nanny.ReleaseToNannyTask, YaMakeTask):

    """Build Answers recommender binaries."""

    type = 'BUILD_ANSWERS_RECOMMENDER_BINARIES'

    TARGET_RESOURCE_TYPES = [
        resources.AnswersRecommender,
        resources.AnswersRecommenderIndexBuilder
    ]

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    def get_targets(self):
        return [resource_type.arcadia_build_path
                for resource_type in self.TARGET_RESOURCE_TYPES]

    def get_resources(self):
        resources = {}

        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': resource_type.arcadia_build_name
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [
            {
                'path': resource_type.arcadia_build_path,
                'dest': resource_type.arcadia_build_name
            }
            for resource_type in self.TARGET_RESOURCE_TYPES
        ]


__Task__ = BuildAnswersRecommenderBinaries
