from marshmallow import Schema, fields, pre_dump

SEX_UNDEFINED = '0'
SEX_MAN = '1'
SEX_WOMAN = '2'

SEX_USER_MAPPING = {
    SEX_UNDEFINED: None,
    SEX_MAN: 'm',
    SEX_WOMAN: 'f',
}


def get_user_sex_repr(sex_id):
    result = SEX_USER_MAPPING.get(sex_id, None)
    return result


class UserSchema(Schema):
    id = fields.String(dump_only=True)
    uuid = fields.Number(dump_only=True, attribute='yandex_uid')
    login = fields.String(dump_only=True)
    displayName = fields.String(dump_only=True, attribute='display_name')
    avatarId = fields.String(dump_only=True, attribute='avatar_id')
    userType = fields.String(dump_only=True, attribute='user_type')

    sex = fields.String(dump_only=True)

    about = fields.String(default='')

    showLogin = fields.Boolean(attribute='show_login')
    trustLevel = fields.Integer(dump_only=True, attribute='trust_level')
    url = fields.String(dump_only=True)

    rating = fields.Integer(dump_only=True)

    created = fields.DateTime(dump_only=True)
    updated = fields.DateTime(dump_only=True)

    @pre_dump
    def handle_sex(self, data):
        if not isinstance(data, dict):
            data = dict(data)

        if 'sex' in data:
            data['sex'] = get_user_sex_repr(data['sex'])

        return data
