from sandbox.projects.common.nanny.client import NannyClient
from sandbox import sdk2
from sandbox.common.errors import SandboxException
import logging


class DeployNannyDashboardRecipeOptional(sdk2.Task):
    '''
        Deploy some nanny dashboard recipe.
    '''
    NANNY_API_URL = 'http://nanny.yandex-team.ru/'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # Mb

    class Parameters(sdk2.Task.Parameters):
        dashboard_id = sdk2.parameters.String(
            'Nanny dashboard id', required=False)
        dashboard_recipe_id = sdk2.parameters.String(
            'Nanny dashboard recipe id', required=False)
        nanny_token_vault_id = sdk2.parameters.String(
            'Nanny token sandbox vault item id', required=False)
        nanny_token_vault_owner = sdk2.parameters.String(
            'Nanny token sandbox vault item owner', required=False)
        do_deploy = sdk2.parameters.Bool(
            'If actually run deploy recipe. No actions otherwise.', default=False)

    def on_execute(self):
        if not self.Parameters.do_deploy:
            logging.info('Exit with no actions.')
            return

        # Required fields to run the recipe
        required_fields = [
            'dashboard_id', 'dashboard_recipe_id', 'nanny_token_vault_id', 'nanny_token_vault_owner'
        ]
        if not all(p for p in required_fields):
            raise SandboxException("Some of the required files to run the recipe are missing.")

        logging.info('Deploy dashboard recipe.')

        nanny_token = sdk2.Vault.data(self.Parameters.nanny_token_vault_owner, self.Parameters.nanny_token_vault_id)
        nanny_client = NannyClient(api_url=self.NANNY_API_URL, oauth_token=nanny_token)
        nanny_client.deploy_dashboard(
            self.Parameters.dashboard_id,
            self.Parameters.dashboard_recipe_id,
            use_latest_snapshot=True
        )
