# -*- coding: utf-8 -*-


def bytes_in(s):
    return len(s.encode('utf-8'))


class Sitemap(object):
    MAX_URLS = 50000
    MAX_BYTES = 10 * 1024 * 1024
    TEMPLATE = u'''<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">{urls}</urlset>'''

    def __init__(self, urls=()):
        if len(urls) > Sitemap.MAX_URLS:
            raise ValueError('Sitemap can hold no more than {} urls'.format(Sitemap.MAX_URLS))
        data = Sitemap.TEMPLATE.format(
            urls=''.join(urls)
        )
        if bytes_in(data) > Sitemap.MAX_BYTES:
            raise ValueError('Sitemap should be no bigger than {} bytes'.format(Sitemap.MAX_BYTES))
        self.data = data


class Series(object):
    def __init__(self, urls):
        self.sitemaps = []
        sizeof_empty_sitemap = bytes_in(Sitemap().data)
        current_size = sizeof_empty_sitemap
        current_urls = []
        for url in urls:
            if len(current_urls) + 1 > Sitemap.MAX_URLS or current_size + bytes_in(url) > Sitemap.MAX_BYTES:
                self.sitemaps.append(Sitemap(current_urls))
                current_size = sizeof_empty_sitemap
                current_urls = []
            current_urls.append(url)
            current_size += bytes_in(url)
        if current_urls:
            self.sitemaps.append(Sitemap(current_urls))
