# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

import os
from dateutil import parser


def get_last_dump_dir(yt_client, yt_dumps_directory):
    all_subdirs = yt_client.list(yt_dumps_directory)
    if 'latest' in all_subdirs:
        last_dump_dir = 'latest'
    else:
        last_dump_dir = max(all_subdirs, key=lambda x: parser.parse(x))
    abs_path = os.path.join(yt_dumps_directory, last_dump_dir)
    return abs_path
