from sandbox import sdk2


class Environments(object):
    DEV = 'development'
    PROD = 'production'
    PRESTABLE = 'prestable'
    TEST = 'testing'


class CeleryBinary(sdk2.Resource):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'contrib/python/celery/py2/bin'
    arcadia_build_name = 'celery'
    releasers = [
        "anoh",
        "dshmatkov",
        "kasperovich",
        "yaskevich",
        "xenos",
        "yseredich",
        "nexidan",
        "proskurnev",
        "robot-answers",
        "dobrowin",
        "s-chabarov",
        "semyonmo",
        "panovav",
        "dan-chir",
        "alekseyzotov",
        "vkorbut",
        "sersmirnov",
        "waser",
        "katsura-a"
    ]


class AnswersResourceBase(sdk2.Resource):
    releasers = [
        "ANSWERS",
        "anoh",
        "dshmatkov",
        "yaskevich",
        "nexidan",
        "next0",
        "ftdebugger",
        "robot-answers",
        "robot-hitman",
        "robot-pdb-builder",
        "volodskikh",
        "kasperovich",
        "xenos",
        "yseredich",
        "dan-chir",
        "proskurnev",
        "dobrowin",
        "s-chabarov",
        "semyonmo",
        "panovav",
        "alekseyzotov",
        "vkorbut",
        "sersmirnov",
        "golman",
        "waser",
        "kirkutyrev",
        "katsura-a",
        "ukandruseu"
    ]


class AnswersBackendServer(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBackendAdminServer(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBackendCeleryWorker(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBackendCeleryBeat(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBackendYasm(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBackendHistory(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersBlackboxProxy(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersPostgresql(AnswersResourceBase):
    """PostgreSQL binaries created to simulate prod postgres
    while running tests in arcadia.
    """
    pass


class AnswersBackendCeleryWorkerAwsData(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersTheQuestionDownloadServer(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersTheQuestionServer(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True


class AnswersPostgresqlDump(AnswersResourceBase):
    auto_backup = True
    env = sdk2.Attributes.String('Environment')


class AnswersSeriesPostgresqlDump(AnswersResourceBase):
    auto_backup = True
    env = sdk2.Attributes.String('Environment')


class AnswersTheQuestionPostgresqlDump(AnswersResourceBase):
    auto_backup = True
    env = sdk2.Attributes.String('Environment')


class AnswersFeedReader(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers_feed/feed_reader/app'
    arcadia_build_name = 'answers_feed_reader'


class AnswersFeedReaderIndexBuilder(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers_feed/feed_reader/index/index_builder'
    arcadia_build_name = 'answers_index_builder'


class AnswersFeedReaderData(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersRecommender(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers_recommender/app'
    arcadia_build_name = 'answers_recommender'


class AnswersDjRecommender(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers_recommender/dj/recommender/app/answers_dj_recommender'
    arcadia_build_name = 'answers_dj_recommender'


class AnswersDjRtyserverBin(AnswersResourceBase):
    """
        Executable for dj-saas recommender
    """
    releasable = True
    executable = True
    auto_backup = True


class AnswersDjRecommenderBundle(AnswersResourceBase):
    """
        Bundle for answers static basesearch recommender
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class AnswersDjRtRecommenderBundle(AnswersResourceBase):
    """
        Bundle for answers realtime basesearch recommender
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class AnswersDjShard2RecommenderBundle(AnswersResourceBase):
    """
        Bundle for answers dj shard2 recommender deployment
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True


class AnswersDjRecommenderModelsArchive(AnswersResourceBase):
    """
        Models archive for answers dj recommender deployment
    """
    any_arch = True
    executable = False
    releasable = True


class AnswersBasesearchRecommenderModels(AnswersResourceBase):
    """
        Directory with models for answers basesearch recommender
    """
    any_arch = True
    executable = False
    releasable = True


class AnswersDjRecommenderDiv2JsonTemplates(AnswersResourceBase):
    """
        Templates with div2json for informer.
    """
    any_arch = True
    executable = False
    releasable = True


class AnswersRecommenderIndexBuilder(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers_recommender/index/index_builder'
    arcadia_build_name = 'recommender_index_builder'


class AnswersRecommenderData(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersRecommenderDjShard(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersRecommenderDjShard2(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersRecommenderDjFastShard(AnswersResourceBase):
    releasable = True
    auto_backup = True


class AnswersRecommenderDjShardmap(AnswersResourceBase):
    releasable = True
    auto_backup = False


class AnswersSuggestTagsData(AnswersResourceBase):
    releasable = True
    auto_backup = True
    env = sdk2.Attributes.String('Environment')


class AnswersSuggestUsersData(AnswersResourceBase):
    releasable = True
    auto_backup = True
    env = sdk2.Attributes.String('Environment')


class AnswersSiteMap(AnswersResourceBase):
    any_arch = False
    auto_backup = True
    releasable = True


class QSiteMap(AnswersResourceBase):
    any_arch = False
    auto_backup = True
    releasable = True


class AnswersTheQuestionSiteMap(AnswersResourceBase):
    any_arch = False
    auto_backup = True
    releasable = True


class AnswersDatabaseMigrator(AnswersResourceBase):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers/database_migrations'
    arcadia_build_name = 'database_migrator'


class AnswersExporter(sdk2.Resource):
    releasable = True
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/yasap/answers/populate_turbo'
    arcadia_build_name = 'populate_answers_for_turbo'


class AnswersCtl(AnswersResourceBase):
    executable = True
    auto_backup = True


class AnswersConfig(sdk2.Resource):
    """ Answ config """
    filename = 'config.conf'
    env = sdk2.Attributes.String('Environment')


class AnswersStressAmmo(sdk2.Resource):
    """ Answers stresstest ammo file """
    filename = 'stress_ammo_file'
