import logging
import os
from os.path import join as join_path, realpath, dirname

from sandbox.common.types.misc import DnsType
from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AAB_MORDA_TEMPLATES_SQL_TO_YT(sdk2.Task):
    """ Copy table with awaps banner templates from sql to YT. """
    class Requirements(sdk2.Requirements):
        dns = DnsType.DNS64  # for external interactions
        privileged = True  # to run apt-get installs in build-all script

    class Parameters(sdk2.Task.Parameters):
        _container = sdk2.parameters.Container(
            "Environment container resource",
            default_value='516606653',
            required=True
        )

    def on_execute(self):
        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
        os.environ['YT_TOKEN'] = yav_secrets["ANTIADBLOCK_YT_TOKEN"]
        os.environ['SQL_PASSWORD'] = yav_secrets["ANTIADBLOCK_PASSWORD"]
        script_path = join_path(dirname(realpath(__file__)), 'aab_adids_templates.py')
        logging.info(script_path)
        run_process(['python', script_path], log_prefix='request_sql', shell=True)
