#!/usr/bin/python
# -*- coding: utf-8 -*-
import os

import yt.wrapper as yt


QUERY = '''
select DISTINCT
    a.adid, t.nmb as template_nmb, t.name as template_name
from (
    select
    xm_BANNER_KEY as adid, xm_bannerstore_creative_nmb
    from aw_master.dbo.v_banner with (nolock)
    where xm_bannerstore_creative_nmb is not NULL
    ) a
    join RAPIDC.BannerStorage.dbo.t_creative_version cv with (nolock) on cv.creative_nmb = a.xm_bannerstore_creative_nmb
    join RAPIDC.BannerStorage.dbo.t_template_version tv with (nolock) on tv.nmb = cv.template_version_nmb
    join RAPIDC.BannerStorage.dbo.t_template t with (nolock) on t.nmb = tv.template_nmb
'''


def fill_out_table():
    import pymssql

    yt.config["proxy"]["url"] = "hahn"
    yt.config["token"] = os.environ['YT_TOKEN']

    conn = pymssql.connect(host='sqllogc.yandex.ru:1433', user='robot_banner', password=os.environ['SQL_PASSWORD'])
    cursor = conn.cursor(as_dict=True)
    cursor.execute(QUERY)
    table_json = cursor.fetchall()

    yt.write_table(
        "//home/antiadb/monitorings/adid_template", table_json,
        format=yt.JsonFormat(attributes={"encode_utf8": False})
    )


if __name__ == '__main__':
    fill_out_table()
