# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.common.types.task as ctt
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sdk2 import parameters
from sandbox.projects.common.nanny import nanny

import time

from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AntiadblockAllCookies(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


class AntiadblockAllCookiesBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


class AntiadblockCookiesTask(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Task that collects all cookies to SB resource"""

    class Requirements(sdk2.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        dbname = parameters.String('Database Name', required=True, default='aab_admin_yandex_team_ru_db')
        host = parameters.String('Database Host', required=True, default='sas-w9jnn4x6osfkn7nh.db.yandex.net')
        port = parameters.Integer('Database Port', required=True, default=6432)
        username = parameters.String('Database User', required=True, default='antiadb')
        auto_release = sdk2.parameters.Bool('Nanny auto release', required=True, default=False)

        binary_id = sdk2.parameters.LastReleasedResource(
            'Antiadblock Cookies binary',
            resource_type=AntiadblockAllCookiesBin,
            state=(ctr.State.READY,),
            required=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        env = {
            'PG_CONN_STR':
                "sslmode=require dbname='{dbname}' user='{user}' host='{host}' port={port} password='{password}'".format(
                    dbname=self.Parameters.dbname,
                    user=self.Parameters.username,
                    host=self.Parameters.host,
                    port=self.Parameters.port,
                    password=sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADB_DB_PASSWORD']
                )
        }
        cmd = [
            str(bin_res.path)
        ]
        with sdk2.helpers.ProcessLog(self, logger="aab_cookies") as l:
            cookies = sp.check_output(cmd, stderr=l.stderr, env=env)
            with open("cookies.txt", mode='a') as file:
                file.write(cookies)
            sdk2.ResourceData(AntiadblockAllCookies(
                self, "Output file", "cookies.txt"
            )).ready()

        if not self.Parameters.auto_release:
            return

        self.on_release(dict(
            releaser=self.author,
            release_status=ctt.ReleaseStatus.STABLE,
            release_subject="Antiadblock cookies autorelease at {current_time}".format(current_time=time.asctime()),
            email_notifications=dict(to=[], cc=[]),
        ))
