# -*- coding: utf-8 -*-
import os
import json

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr

import sandbox.projects.common.network as network
from sandbox.projects.antiadblock.aab_selenoid_basic_executor import Antiadblock_Selenoid_Basic_Executor
from sandbox.projects.antiadblock.aab_automerge_ext import AdblockplusChromeExtension, AdblockplusFirefoxExtension, \
    AdguardChromeExtension, AdguardFirefoxExtension, UblockChromeExtension, UblockFirefoxExtension, \
    AdblockChromeExtension, AdblockFirefoxExtension
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID
from sandbox.projects.antiadblock.aab_argus_utils import (
    AntiadblockChromeExtensionModHeader,
    AntiadblockFirefoxExtensionModHeader,
    AntiadblockChromeExtensionModCookie,
    AntiadblockFirefoxExtensionModCookie,
    AntiadblockArgusBin,
    get_extension_path,
    get_extension_http_url,
)


class Antiadblock_Argus_Screenshoter(Antiadblock_Selenoid_Basic_Executor):
    """Takes screenshots of all specified pages with adblocks"""

    class Parameters(Antiadblock_Selenoid_Basic_Executor.Parameters):
        argus_run_id = sdk2.parameters.Integer('Argus run id', default=0)
        url_profile = sdk2.parameters.String('Partner profile settings, json list of links and selectors to hide to take screenshot', default="[]")
        without_s3 = sdk2.parameters.Bool('Do not use s3 to save results, only save locally', default=False)
        argus_resource_id = sdk2.parameters.Integer('Argus resource id', required=False)

        env_vars = sdk2.parameters.String('Optional environment variables (expecting "var1=val1;var2=val2")', required=False)
        task_kill_timeout = sdk2.parameters.Integer('Timeout in minutes after that task will be kill by sandbox',
                                                    default=80 * 60)

    @staticmethod
    def get_modheader_extensions_path():
        return dict(
            CHROME_MODHEADER=get_extension_path(AntiadblockChromeExtensionModHeader),
            FIREFOX_MODHEADER=get_extension_path(AntiadblockFirefoxExtensionModHeader),
        )

    @staticmethod
    def get_modcookie_extensions_path():
        return dict(
            CHROME_MODCOOKIE=get_extension_path(AntiadblockChromeExtensionModCookie),
            FIREFOX_MODCOOKIE=get_extension_path(AntiadblockFirefoxExtensionModCookie),
        )

    @staticmethod
    def get_adblock_extensions_path():
        return dict(
            ADBLOCK_CHROME=get_extension_http_url(AdblockChromeExtension),
            ADBLOCK_FIREFOX=get_extension_http_url(AdblockFirefoxExtension),
            ADBLOCK_PLUS_CHROME=get_extension_http_url(AdblockplusChromeExtension),
            ADBLOCK_PLUS_FIREFOX=get_extension_http_url(AdblockplusFirefoxExtension),
            ADGUARD_CHROME=get_extension_http_url(AdguardChromeExtension),
            ADGUARD_FIREFOX=get_extension_http_url(AdguardFirefoxExtension),
            UBLOCK_ORIGIN_CHROME=get_extension_http_url(UblockChromeExtension),
            UBLOCK_ORIGIN_FIREFOX=get_extension_http_url(UblockFirefoxExtension),
        )

    def execute_code(self, browsers_config, selenoid_config):
        resource_class = AntiadblockArgusBin
        if self.Parameters.argus_resource_id:
            binary_id = sdk2.Resource[self.Parameters.argus_resource_id]
        else:
            binary_id = sdk2.Resource.find(
                resource_type=resource_class,
                state=ctr.State.READY,
                attrs=dict(release='stable'),
            ).limit(1).first()
        bin_res = sdk2.ResourceData(binary_id)
        profile = json.loads(self.Parameters.url_profile)
        profile["run_id"] = self.Parameters.argus_run_id

        env = os.environ.copy()
        env['EXTENSIONS'] = json.dumps(dict(
            modheaders=self.get_modheader_extensions_path(),
            modcookies=self.get_modcookie_extensions_path(),
            adblocks=self.get_adblock_extensions_path(),
        ))
        env['PROFILE'] = json.dumps(profile)
        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
        env['S3_SECRET_KEY'] = yav_secrets['ANTIADBLOCK_S3_SECRET_KEY']
        env['S3_KEY_ID'] = yav_secrets['ANTIADBLOCK_S3_KEY_ID']
        env['SELENIUM_EXECUTOR_JSON'] = json.dumps(browsers_config)
        env['SELENOID_CONFIG'] = json.dumps(selenoid_config)
        env['SANDBOX_TASK_ID'] = str(self.id)
        env['EXTERNAL_IP'] = network.get_my_ipv6()

        if self.Parameters.env_vars:
            for kv in self.Parameters.env_vars.strip().strip(';').split(';'):
                key, value = kv.split('=')
                env[key.strip()] = value.strip()

        cmd = [str(bin_res.path)]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
