import requests
from sandbox import sdk2
import sandbox.common.types.resource as ctr


SELENOID_CONFIG = {
    "chrome": {
        "selenium_browser_name": "chrome",
        "default": "98.0",
        "versions": {
            "98.0": {
                "path": "/",
                "image": "selenoid/chrome:98.0",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "port": "4444",
                "shmSize": 1073741824
            },
            "83.0": {
                "path": "/",
                "image": "selenoid/chrome:83.0",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "port": "4444",
                "shmSize": 536870912
            }
        }
    },
    "yandex-browser": {
        "selenium_browser_name": "chrome",
        "default": "20.7.2.51",
        "versions": {
            "22.3.0.127": {
                "path": "/",
                "image": "registry.yandex.net/selenoid/yabro:22.3.0.127",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "port": "4444",
                "shmSize": 1073741824
            },
            "20.7.2.51": {
                "path": "/",
                "image": "registry.yandex.net/selenoid/yabro:20.7.2.51",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "port": "4444",
                "shmSize": 1073741824
            }
        }
    },
    "firefox": {
        "selenium_browser_name": "firefox",
        "default": "79.0",
        "versions": {
            "79.0": {
                "path": "/wd/hub",
                "image": "registry.yandex.net/selenium/firefox:dev-79.0",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "port": "4444",
                "shmSize": 1073741824
            }
        }
    },
    "opera": {
        "selenium_browser_name": "opera",
        "default": "74.0",
        "versions": {
            "83.0": {
                "image": "selenoid/opera:83.0",
                "port": "4444",
                "path": "/",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "shmSize": 1073741824
            },
            "74.0": {
                "image": "selenoid/opera:74.0",
                "port": "4444",
                "path": "/",
                "tmpfs": {
                    "/tmp": "size=256m"
                },
                "shmSize": 1073741824
            }
        }
    }
}


class AntiadblockArgusBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]

    release = sdk2.resource.Attributes.String("Release")


class AntiadblockChromeExtensionModHeader(AntiadblockArgusBin):
    pass


class AntiadblockFirefoxExtensionModHeader(AntiadblockArgusBin):
    pass


class AntiadblockChromeExtensionModCookie(AntiadblockArgusBin):
    pass


class AntiadblockFirefoxExtensionModCookie(AntiadblockArgusBin):
    pass


def get_extension_http_url(resource_type, sync_resource=True):
    latest_resource = get_latest_resource(resource_type)
    if sync_resource:
        sdk2.ResourceData(latest_resource)  # sync latest resource
    ext_url = latest_resource.url
    response = requests.get(ext_url)
    response.raise_for_status()
    api_url = response.json()["url"]
    response = requests.get(api_url + "/data/http")
    response.raise_for_status()

    for host in response.json():
        if host["state"] == "OK" and host["alive"]:
            return host["url"]
    return ""


def get_extension_path(resource_type):
    return str(sdk2.ResourceData(get_latest_resource(resource_type)).path)


def get_latest_resource(resource_type):
    return sdk2.Resource.find(
        resource_type=resource_type,
        state=ctr.State.READY,
    ).limit(1).first()
