# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.resource as ctr
import sandbox.common.types.client as ctc
from sandbox.common.types.misc import DnsType

from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID

AUTOMERGE_CONTAINER = 3269508082


class AntiadblockAutomergeTaskBin(sdk2.Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


class AdblockChromeExtension(AntiadblockAutomergeTaskBin):
    pass


class AdblockFirefoxExtension(AntiadblockAutomergeTaskBin):
    pass


class AdblockplusChromeExtension(AntiadblockAutomergeTaskBin):
    pass


class AdblockplusFirefoxExtension(AntiadblockAutomergeTaskBin):
    pass


class AdguardChromeExtension(AntiadblockAutomergeTaskBin):
    pass


class AdguardFirefoxExtension(AntiadblockAutomergeTaskBin):
    pass


class UblockChromeExtension(AntiadblockAutomergeTaskBin):
    pass


class UblockFirefoxExtension(AntiadblockAutomergeTaskBin):
    pass


class AntiadblockAutomergeExtensions(sdk2.Task):
    name = 'ANTIADBLOCK_AUTOMERGE_EXTENSIONS'

    class Requirements(sdk2.Task.Requirements):
        cores = 2
        privileged = True  # for root
        client_tags = ctc.Tag.LINUX_XENIAL
        dns = DnsType.DNS64  # for external interactions

    class Parameters(sdk2.Task.Parameters):
        _container = sdk2.parameters.Container(
            'LXC container for ANTIADBLOCK automerge task',
            default_value=AUTOMERGE_CONTAINER,
            platform='linux_ubuntu_16.04_xenial',
            required=True,
        )

    def get_resource_or_none(self, resource_class, name, path):
        if os.path.isfile(path):
            return resource_class(self, name, path)
        return None

    def on_execute(self):
        resource_class = AntiadblockAutomergeTaskBin
        binary_id = sdk2.Resource.find(
            resource_type=resource_class,
            state=ctr.State.READY
        ).limit(1).first()
        bin_res = sdk2.ResourceData(binary_id)

        env = os.environ.copy()
        env['ARC_TOKEN'] = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['OAUTH_TOKEN']

        if getattr(self.Parameters, 'env_vars', None):
            for kv in self.Parameters.env_vars.strip().strip(';').split(';'):
                key, value = kv.split('=')
                env[key.strip()] = value.strip()

        cmd = [str(bin_res.path)]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
