import logging
import os
from json import loads

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.errors import TaskError
from sandbox.sdk2.helpers import ProcessLog

from sandbox.projects.antiadblock.aab_checklist.aab_checklist_fake_task import FakeAntiadbCheckTask
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID

CHECK_TASKS = [FakeAntiadbCheckTask]
FILENAME = 'services.json'


class HeadAntiadbChecklistTask(sdk2.Task):

    class Parameters(sdk2.Parameters):
        _container = sdk2.parameters.Container(
            'tvm2 environment container',
            default_value=582960420,
            required=True
        )

    def on_execute(self):
        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
        os.environ['TVM_ID'] = yav_secrets['ANTIADBLOCK_CHECKLIST_TEST_TVM_ID']
        os.environ['TVM_SECRET'] = yav_secrets['ANTIADBLOCK_CHECKLIST_TEST_TVM_SECRET']
        # Read services list from configs_api and write it to file
        script_path = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'get_service_list.py')
        cmd = '. /usr/local/vennv/bin/activate && python {}'.format(script_path)
        with ProcessLog(self, 'script') as pl:
            try:
                sp.check_output(cmd, stderr=pl.stdout, shell=True)
            except Exception:
                raise TaskError('Cannot get services list from config_api')

        with open(FILENAME, 'r') as s_file:
            services = loads(s_file.read())

        # Run every task for every service
        for task in CHECK_TASKS:
            task_description = 'Create task {}'.format(task.__name__)
            task_id = task(self,
                           description=task_description,
                           owner=self.owner,
                           services=services,
                           notifications=[{'transport': 'email', 'statuses': ['FAILURE', 'EXCEPTION', 'TIMEOUT'],
                                           'recipients': ['ddemidov']}],).enqueue().id
            logging.info('Enqueued task "{}" with id: {}'.format(task_description, task_id))
