import random
import logging
import json

from sandbox import sdk2


class AntiadbCheckResultFile(sdk2.Resource):
    """JSON with task result"""


class FakeAntiadbCheckTask(sdk2.Task):

    class Parameters(sdk2.Parameters):
        services = sdk2.parameters.JSON('Dict of services', required=True, default=dict())

    def on_execute(self):
        services_mapping = dict()
        # Log service_id and return random status
        logging.info(self.Parameters.services.keys())
        for service in self.Parameters.services.keys():
            services_mapping[service] = 'ok' if random.choice([True, False]) else 'fail'

        result_file = sdk2.ResourceData(AntiadbCheckResultFile(
            self, "Output file", "services.json"
        ))
        result_file.path.write_bytes(json.dumps(services_mapping))
