import os

import requests


CONFIGSAPI_URL = "https://aab-admin-api-develop.qams.yandex.ru/v2/configs?status=active"
FILENAME = 'services.json'


if __name__ == '__main__':
    from tvm2 import TVM2
    from tvmauth import BlackboxTvmId as BlackboxClientId

    tvm = TVM2(
        client_id=os.environ['TVM_ID'],
        secret=os.environ['TVM_SECRET'],
        blackbox_client=BlackboxClientId.Prod,
        allowed_clients=(),
        destinations=["2000627"])

    # Get all services from config_api
    response = requests.get(
        CONFIGSAPI_URL,
        headers={
            'X-Ya-Service-Ticket': tvm.get_service_tickets("2000627").get("2000627")
        },
        verify=False
    )

    with open(FILENAME, 'w') as s_file:
        s_file.write(response.text)
