from sandbox import sdk2
from sandbox.sandboxsdk import environments as envs
from sandbox.common.types.misc import DnsType
from sandbox.sandboxsdk.process import run_process as sdk_run_process
from sandbox.sandboxsdk.ssh import Key
from sandbox.sandboxsdk import svn

VAULT_OWNER = "robot-antiadb"
VAULT_SSH = "ANTIADBLOCK_ROBOT_SSH_PRIVATE_KEY"

PYTHON_COMMAND = 'python'
ANSIBLE_COMMAND = 'ansible-playbook'
ARCADIA_AAB_ANSIBLE_PATH = 'arcadia:/arc/trunk/arcadia/antiadblock/cryprox/ansible/'
PIP_COMMAND = 'pip'
ANSIBLE_GALAXY_COMMAND = 'ansible-galaxy'


def run_process(cmd, log_prefix, **kwargs):
    return sdk_run_process(cmd, shell=True, log_prefix=log_prefix, **kwargs)


class AAB_TEST_DEPLOY_CRYPROX(sdk2.Task):
    """deploy antiadblock cryprox to test cluster using ansible"""

    dns = DnsType.DNS64

    class Parameters(sdk2.Parameters):
        host = sdk2.parameters.String("host",
                                      default='cryproxtestload-man-1.aab.yandex.net')
        tag = sdk2.parameters.String("tag")
        deploy_cry_proxy = sdk2.parameters.Bool("Deploy cryprox", default=True)
        deploy_nginx = sdk2.parameters.Bool("Deploy nginx", default=False)
        deploy_cookie_matcher = sdk2.parameters.Bool("Deploy cookiematcher", default=False)

    def checkout_ansible(self):
        svn.Arcadia.export(ARCADIA_AAB_ANSIBLE_PATH, self.ansible_path)

    def on_execute(self):
        self.ansible_path = str(self.path('ansible_dir'))
        self.checkout_ansible()
        with envs.VirtualEnvironment():
            with Key(self, VAULT_OWNER, VAULT_SSH):
                run_process(['curl', 'https://bootstrap.pypa.io/get-pip.py', '|', PYTHON_COMMAND, '-'],
                            'install_pip')

                run_process([PIP_COMMAND, 'install',
                             '-i', 'https://pypi.python.org/simple',
                             '--extra-index-url', 'https://pypi.yandex-team.ru/simple',
                             '--retries', '10',
                             'ansible',
                             ],
                            'install_ansible')

                run_process([ANSIBLE_GALAXY_COMMAND, 'install',
                             '-f', '-r', self.ansible_path + '/requirements.yml',
                             ],
                            'install_ansible_galaxy')

                tag = str(self.Parameters.tag)
                inventory_file_path = self.ansible_path + '/test'
                playbooks_path = self.ansible_path + '/playbooks/'
                base_cmd_params = [ANSIBLE_COMMAND,
                                   '-i', inventory_file_path,
                                   '-l', self.Parameters.host,
                                   '--skip-tags', 'svn_diff_check']

                if self.Parameters.deploy_cry_proxy:
                    run_process(base_cmd_params +
                                [playbooks_path + 'cryprox-only.yml',
                                 '--extra-vars', '"cryprox_tag={}" secdist_user={}'.format(tag, VAULT_OWNER)],
                                log_prefix='ansible_cryprox'
                                )

                if self.Parameters.deploy_nginx:
                    run_process(base_cmd_params +
                                [playbooks_path + 'nginx-only.yml',
                                 '--extra-vars', '"nginx_tag={} secdist_user={}"'.format(tag, VAULT_OWNER)],
                                log_prefix='ansible_nginx'
                                )

                if self.Parameters.deploy_cookie_matcher:
                    run_process(base_cmd_params +
                                [playbooks_path + 'cookiematcher-only.yml',
                                 '--extra-vars', '"cookiematcher_tag={} secdist_user={}"'.format(tag, VAULT_OWNER)],
                                log_prefix='ansible_cookiematcher'
                                )
