import logging
import os

from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.sandboxsdk import environments as envs
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AAB_DUTY(sdk2.Task):
    """ Updates Antiadblock duty table (in the nearest future) and phone redirection. """

    class Requirements(sdk2.Requirements):
        cores = 1
        environments = [
            envs.PipEnvironment('yql'),
            envs.PipEnvironment('yandex-yt'),
            envs.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            envs.PipEnvironment('python-statface-client', use_wheel=True, version='0.90.0'),
        ]
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='AAB_DUTY_SEM', weight=1, capacity=1)
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH, ctt.Status.Group.WAIT)
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        with envs.VirtualEnvironment() as venv:
            envs.PipEnvironment('yql', venv=venv).prepare()
            envs.PipEnvironment('requests', venv=venv).prepare()
            envs.PipEnvironment('yandex-yt-yson-bindings-skynet', venv=venv, use_wheel=True).prepare()
            envs.PipEnvironment('yandex-yt', venv=venv, use_wheel=True).prepare()

            yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
            os.environ['YT_TOKEN'] = yav_secrets['ANTIADBLOCK_YT_TOKEN']
            os.environ['OAUTH_TOKEN'] = yav_secrets['OAUTH_TOKEN']

            script_path = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'job.py')
            logging.info(script_path)
            run_process([venv.executable, script_path], log_prefix='new_duty_routine', shell=True)
