import os
import datetime

import requests

from yql.api.v1.client import YqlClient


STAFF_URL = 'https://api.staff.yandex-team.ru/v3/persons'
TELEGRAPH_URL = 'https://telegraph.yandex.net/api/v3/cucm/translation_pattern/pattern/{}'
ROBOT_PHONE_NO = 80640


def get_duty_login(yt_token):
    client = YqlClient(token=yt_token, db='hahn')
    today = datetime.datetime.today()
    week = today - datetime.timedelta(days=today.weekday())
    query = 'SELECT support FROM [home/antiadb/monitorings/support_schedule] WHERE week="{}"'.format(week.strftime("%d-%m-%Y"))
    result = client.query(query).run().get_results()
    duty_login = result.table.rows[0][0]
    return duty_login


def get_duty_phone_no(duty_login, oauth_token):
    response = requests.get(
        STAFF_URL, params={'_one': 1, 'login': duty_login},
        headers={'Authorization': 'OAuth {}'.format(oauth_token)}
    )
    duty_phone_no = response.json()['work_phone']
    return duty_phone_no


def apply_phone_forwarding(duty_phone_no, oauth_token):
    result = requests.put(
        TELEGRAPH_URL.format(ROBOT_PHONE_NO),
        data='{{"calledPartyTransformationMask": "{}"}}'.format(duty_phone_no),
        headers={'Authorization': 'OAuth {}'.format(oauth_token), 'Content-Type': 'application/json'},
    )
    print 'phone forwarding result', result.text


if __name__ == '__main__':
    yt_token = os.environ['YT_TOKEN']
    oauth_token = os.environ['OAUTH_TOKEN']
    duty_login = get_duty_login(yt_token)
    duty_phone_no = get_duty_phone_no(duty_login, oauth_token)
    apply_phone_forwarding(duty_phone_no, oauth_token)
