# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.common.types.task as ctt
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AntiadblockPushBalancerSettingsBin(sdk2.Resource):
    """
    antiadblock/tasks/push_balancer_crypto_settings binary
    """
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]

class AntiadblockPushBalancerSettingsTask(sdk2.Task):
    """Task that pushes crypto settings to balancers ITS"""

    class Requirements(sdk2.Requirements):
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='AAB_BALANCERS_ITS')
            ]
        )

    class Parameters(sdk2.Task.Parameters):
        env_vars = sdk2.parameters.String('Optional environment variables (expecting "var1=val1;var2=val2")', required=False)

    def on_execute(self):
        binary_id = sdk2.Resource.find(
            resource_type=AntiadblockPushBalancerSettingsBin,
            state=ctr.State.READY,
            attrs=dict(released='stable')
        ).limit(1).first()
        bin_res = sdk2.ResourceData(binary_id)

        env = {
            'CONFIGS_API_HOST': 'api.aabadmin.yandex.ru',
            'CONFIGSAPI_TVM_ID': '2000629',
            'NANNY_API_HOST': 'ext.its.yandex-team.ru',
            'NANNY_TOKEN': sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_NANNY_OAUTH_TOKEN'],
            'TVM_ID': '2002631',
            'TVM_SECRET': sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET'],
        }

        if self.Parameters.env_vars:
            for kv in self.Parameters.env_vars.strip().strip(';').split(';'):
                key, value = kv.split('=')
                env[key.strip()] = value.strip()

        cmd = [
            str(bin_res.path)
        ]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
