import os.path

from sandbox import sdk2
from sandbox.sandboxsdk import environments as envs
from sandbox.common.types.misc import DnsType
from sandbox.sandboxsdk.process import run_process as sdk_run_process
from sandbox.sandboxsdk.ssh import Key
from sandbox.sandboxsdk import svn

VAULT_OWNER = "robot-antiadb"
VAULT_SSH = "ANTIADBLOCK_ROBOT_SSH_PRIVATE_KEY"

PYTHON_COMMAND = 'python'
ANSIBLE_COMMAND = 'ansible-playbook'
ARCADIA_AAB_CRYPROX_PATH = 'arcadia:/arc/trunk/arcadia/antiadblock/cryprox/'
PIP_COMMAND = 'pip'
ANSIBLE_GALAXY_COMMAND = 'ansible-galaxy'


def run_process(cmd, log_prefix, **kwargs):
    return sdk_run_process(cmd, shell=True, log_prefix=log_prefix, **kwargs)


class AAB_TEST_SHOOT_CRYPROX(sdk2.Task):
    """deploy antiadblock cryprox to test cluster using ansible"""

    dns = DnsType.DNS64

    class Parameters(sdk2.Parameters):
        host = sdk2.parameters.String("host",
                                      default='cryproxtestload-man-1.aab.yandex.net')
        tag = sdk2.parameters.String("tag")

    def checkout_cryprox(self):
        svn.Arcadia.export(ARCADIA_AAB_CRYPROX_PATH, self.cryprox_path)

    def build_stub_generator(self):
        ya = svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', os.path.realpath('ya'))
        run_process([ya, 'make', os.path.join(self.cryprox_path, 'load_test')], log_prefix='build_stub_generator')

    def on_execute(self):
        self.cryprox_path = str(self.path('cryprox_dir'))
        self.ansible_path = os.path.join(self.cryprox_path, 'ansible')
        self.checkout_cryprox()
        with envs.VirtualEnvironment():
            with Key(self, VAULT_OWNER, VAULT_SSH):
                run_process(['curl', 'https://bootstrap.pypa.io/get-pip.py', '|', PYTHON_COMMAND, '-'],
                            'install_pip')

                run_process([PIP_COMMAND, 'install',
                             '-i', 'https://pypi.python.org/simple',
                             '--extra-index-url', 'https://pypi.yandex-team.ru/simple',
                             'ansible',
                             ],
                            'install_ansible')

                run_process([ANSIBLE_GALAXY_COMMAND, 'install',
                             '-f', '-r', self.ansible_path + '/requirements.yml',
                             ],
                            'install_ansible_galaxy')

                self.build_stub_generator()

                run_process([ANSIBLE_COMMAND,
                             '-i', self.ansible_path + '/test',
                             '-l', self.Parameters.host,
                             self.ansible_path + '/playbooks/load-test-prepare-stand.yml',
                             '--extra-vars', '"cryprox_tag=' + str(self.Parameters.tag) + '"'],
                            log_prefix='ansible'
                            )

                run_process(
                    [
                        ANSIBLE_COMMAND,
                        '-i', self.ansible_path + '/test',
                        '-l', self.Parameters.host,
                        self.ansible_path + '/playbooks/load-test-shoot.yml',
                        '--extra-vars', '"cryprox_tag=' + str(self.Parameters.tag) + ' nginx_tag=-"'
                    ],
                    log_prefix='ansible'
                )
