# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.resource as ctr
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AntiadblockUploadParamsBin(sdk2.Resource):
    """
    antiadblock/tasks/decrypt_url_configs binary
    """
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


class AntiadblockUploadParamsTask(sdk2.Task):
    """Task that collects all params for decrypt urls in Vault"""

    class Requirements(sdk2.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        pass

    def on_execute(self):
        binary_id = sdk2.Resource.find(
            resource_type=AntiadblockUploadParamsBin,
            state=ctr.State.READY,
            attrs=dict(released='stable')
        ).limit(1).first()
        bin_res = sdk2.ResourceData(binary_id)

        env = {
            'CONFIGS_API_HOST': 'api.aabadmin.yandex.ru',
            'CONFIGSAPI_TVM_ID': '2000629',
            'SECRET_UUID': 'sec-01dbz0grcabghreabrhjr7chg7',
            'TVM_ID': '2002631',
            'TVM_SECRET': sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET'],
            'YAV_TOKEN': sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_YAV_TOKEN'],
        }
        cmd = [
            str(bin_res.path)
        ]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
