import os
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.types.misc import DnsType
import sandbox.common.types.task as ctt
import sandbox.common.types.client as ctc
import sandbox.common.types.resource as ctr

from sandbox.projects.antiadblock.utils.yt_helpers import get_available_yt_clusters
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AntiadblockMoneyTicketsUpdaterBin(sdk2.Resource):
    """
    antiadblock/tasks/money_tickets_updater binary
    """
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


class AntiadblockMoneyTicketsUpdater(sdk2.Task):
    """ antiadblock/tasks/money_tickets_updater binary from SB resource"""

    class Requirements(sdk2.Requirements):
        cores = 1
        client_tags = ctc.Tag.LINUX_XENIAL
        dns = DnsType.DNS64  # for external interactions
        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name='ANTIADBLOCK_MONEY_TICKETS_UPDATER', weight=1, capacity=2)
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH, ctt.Status.Group.WAIT)
        )

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    def on_execute(self):
        binary_id = sdk2.Resource.find(
            resource_type=AntiadblockMoneyTicketsUpdaterBin,
            state=ctr.State.READY,
        ).limit(1).first()
        bin_res = sdk2.ResourceData(binary_id)
        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
        env = os.environ.copy()
        env['CONFIGS_API_HOST'] = 'api.aabadmin.yandex.ru'
        env['CONFIGSAPI_TVM_ID'] = '2000629'
        env['TVM_ID'] = '2002631'
        env['TVM_SECRET'] = yav_secrets['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET']
        env['YT_TOKEN'] = yav_secrets["ANTIADBLOCK_YT_TOKEN"]
        env['STARTREK_TOKEN'] = yav_secrets['ANTIADBLOCK_ST_TOKEN']
        env['STAT_TOKEN'] = yav_secrets["ANTIADBLOCK_STAT_TOKEN"]
        env['WIKI_TOKEN'] = yav_secrets['ANTIADBLOCK_WIKI_API_OAUTH_TOKEN']
        env['ABC_TOKEN'] = yav_secrets['ANTIADBLOCK_ABC_TOKEN']
        # get available yt clusters
        env['AVAILABLE_YT_CLUSTERS'] = get_available_yt_clusters()
        logging.info('AVAILABLE YT CLUSTERS: {}'.format(env['AVAILABLE_YT_CLUSTERS']))
        cmd = [str(bin_res.path)]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
