import os
import signal

from sandbox import sdk2
from sandbox.sdk2.helpers import ProcessLog, ProcessRegistry, subprocess as sp

from sandbox.projects.yabs.qa.module_base import ModuleBase
from sandbox.projects.yabs.qa.server_interface import LocalServerModuleInterface

from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class ConfigsStubModule(ModuleBase, LocalServerModuleInterface):

    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        self.port = self.adapter.get_port()
        self.configs_api_host = self.adapter.get_configs_api_host()
        self.configs_api_tvm_id = self.adapter.get_configs_api_tvm_id()
        self.stub_path = self.adapter.get_executable_path()

    def get_port(self):
        return self.port

    def __enter__(self):
        env = os.environ.copy()
        env["CONFIG_STUB_PORT"] = str(self.get_port())
        env["CONFIGS_API_HOST"] = self.configs_api_host
        env["CONFIGSAPI_TVM_ID"] = self.configs_api_tvm_id
        # use ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET
        env["TVM_ID"] = "2002631"
        env["TVM_SECRET"] = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET']

        self._stub_log = ProcessLog(logger='configs_stub_log')
        self._stub_log.__enter__()
        self._stub_process = sp.Popen([self.stub_path], stdout=self._stub_log.stdout, stderr=self._stub_log.stderr, env=env)
        ProcessRegistry.register(self._stub_process.pid, [self.stub_path])
        return self

    def __exit__(self, *args):
        self._stub_process.send_signal(signal.SIGKILL)
        self._stub_log.__exit__(*args)
