from sandbox import sdk2
import sandbox.common.types.resource as ctr

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

from sandbox.projects.antiadblock.qa.resource_types import AntiadblockConfigsStubServer
from sandbox.projects.antiadblock.qa.modules.configs_stub_module import ConfigsStubModule
from sandbox.projects.antiadblock.qa.modules.configs_stub_module.adapters.interface import ConfigsStubAdapterInterface


class ConfigsStubParameters(sdk2.Task.Parameters):
    stub_port = sdk2.parameters.Integer(
        'Stub port',
        default_value=5000,
        required=True,
    )
    configs_api_host = sdk2.parameters.String(
        'Configs api host',
        default_value='api.aabadmin.yandex.ru',
        required=True,
    )

    configs_api_tvm_id = sdk2.parameters.String(
        'Configs api tvm_id',
        default_value="2000629",
        required=True,
    )


class ConfigsStubSandboxAdapter(ConfigsStubAdapterInterface, SandboxAdapterBase):

    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_executable_path(self):
        return self.sync_resource(sdk2.Resource.find(resource_type=AntiadblockConfigsStubServer, state=ctr.State.READY).limit(1).first())

    def get_port(self):
        return self.parameters.stub_port

    def get_configs_api_host(self):
        return self.parameters.configs_api_host

    def get_configs_api_tvm_id(self):
        return self.parameters.configs_api_tvm_id

    @staticmethod
    def get_init_parameters_class():
        return ConfigsStubParameters

    def create_module(self):
        return ConfigsStubModule(self)
