from abc import ABCMeta, abstractmethod


class EngineAdapterInterface(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def get_engine_executable_path(self):
        pass

    @abstractmethod
    def get_cryprox_package_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_stub_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_executable_path(self):
        pass

    @abstractmethod
    def get_cache_daemon_key_headers(self):
        pass

    @abstractmethod
    def get_nginx_worker_count(self):
        pass

    @abstractmethod
    def get_cryprox_worker_count(self):
        pass
