from sandbox import sdk2

from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase

from sandbox.projects.antiadblock.qa.utils.constants import NGINX_BINARY_RESOURCE_ID, DiffType
from sandbox.projects.antiadblock.qa.modules.engine_module import EngineModule
from sandbox.projects.antiadblock.qa.modules.engine_module.adapters.interface import EngineAdapterInterface
from sandbox.projects.antiadblock.qa.modules.engine_module.adapters.sandbox.parameters import EngineParameters, generate_parameters_class


class EngineSandboxAdapter(EngineAdapterInterface, SandboxAdapterBase):
    def __init__(self, parameters, task_instance):
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_engine_executable_path(self):
        return self.sync_resource(sdk2.Resource.find(id=NGINX_BINARY_RESOURCE_ID).limit(1).first())

    def get_cryprox_package_path(self):
        return self.sync_resource(self.parameters.cryprox_package_resource)

    def get_cache_daemon_stub_path(self):
        return self.sync_resource(self.parameters.cache_daemon_stub_resource)

    def get_cache_daemon_executable_path(self):
        cache_daemon_executable_res_id = self.parameters.cache_daemon_stub_resource.cache_daemon_res_id
        return self.sync_resource(sdk2.Resource.find(id=cache_daemon_executable_res_id).limit(1).first())

    def get_cache_daemon_key_headers(self):
        return self.parameters.cache_daemon_stub_resource.key_header

    def get_nginx_worker_count(self):
        return self.parameters.nginx_worker_count

    def get_cryprox_worker_count(self):
        return self.parameters.cryprox_worker_count

    @staticmethod
    def get_init_parameters_class(prefix=None):
        return EngineParameters if prefix is None else generate_parameters_class(prefix)

    def create_module(self, stub_dir='', test_type=DiffType.LATENCY, configs_stub_port=8080, profile_clock_type=''):
        return EngineModule(self, stub_dir, test_type, configs_stub_port, profile_clock_type)
