from sandbox import sdk2

from sandbox.projects.antiadblock.qa.resource_types import AntiadblockCryproxPackage, ANTIADBLOCK_CACHE_DAEMON_STUB_DATA


class EngineParameters(sdk2.Task.Parameters):
    # resources
    cache_daemon_stub_resource = sdk2.parameters.Resource(
        'Resource with cache_daemon stub data',
        resource_type=ANTIADBLOCK_CACHE_DAEMON_STUB_DATA,
        required=True)

    cryprox_package_resource = sdk2.parameters.Resource(
        'Resource with cryprox package for sandbox',
        resource_type=AntiadblockCryproxPackage,
        required=True)

    nginx_worker_count = sdk2.parameters.Integer(
        'NGINX worker count',
        default_value=2,
        required=True,
    )

    cryprox_worker_count = sdk2.parameters.Integer(
        'CRYPROX worker count',
        default_value=14,
        required=True,
    )

    replaced_configs = sdk2.parameters.JSON(
        'Replaced configs',
        default_value={},
        required=True,
    )

    # required settings
    tmpfs_size = sdk2.parameters.Integer('Tmpfs size', default_value=0)


def generate_parameters_class(parameters_prefix):

    def prefixed_dict(**kwargs):
        return {'{}{}'.format(k, parameters_prefix): v for k, v in kwargs.items()}

    parameters_dictionary = prefixed_dict(
        cache_daemon_stub_resource=sdk2.parameters.Resource(
            'Resource with cache_daemon stub data',
            resource_type=ANTIADBLOCK_CACHE_DAEMON_STUB_DATA,
            required=True),
        cryprox_package_resource=sdk2.parameters.Resource(
            'Resource with cryprox package for sandbox',
            resource_type=AntiadblockCryproxPackage,
            required=True),
        nginx_worker_count=sdk2.parameters.Integer(
            'NGINX worker count',
            default_value=2,
            required=True,
        ),
        cryprox_worker_count=sdk2.parameters.Integer(
            'CRYPROX worker count',
            default_value=14,
            required=True,
        ),
        replaced_configs=sdk2.parameters.JSON(
            'Replaced configs',
            default_value={},
            required=True,
        )
    )
    parameters_dictionary['__names__'] = tuple(k for k in parameters_dictionary.keys())
    return type('Parameters', (sdk2.Task.Parameters,), parameters_dictionary)
