from sandbox import sdk2

from sandbox.common.types import resource as ctr
from sandbox.projects.common.build.YaPackage import YaPackageResource

from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_DOLBILKA_PLAN


DEFAULT_TTL = 7  # days


class ANTIADBLOCK_DOLBILKA_PLAN(YABS_SERVER_DOLBILKA_PLAN):
    """
    Dolbilka plan for shooting cryprox
    """
    ttl = DEFAULT_TTL


class ANTIADBLOCK_REQUEST_LOG_GZ(sdk2.resource.AbstractResource):
    """
    Request log from antiadb-nginx-request-log
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    ttl = DEFAULT_TTL


class ANTIADBLOCK_CACHE_DAEMON_STUB_DATA(sdk2.resource.AbstractResource):
    """
    Dump of cachedaemon filesystem cache + cachedaemon configs used in cryprox tests
    """
    auto_backup = True
    cache_daemon_res_id = sdk2.Attributes.Integer("CACHE_DAEMON resource id", required=True)
    provided_tags = sdk2.Attributes.String('External tags provided by stub', required=False)
    key_header = sdk2.Attributes.String('Key header', required=False)
    testenv_switch_trigger = sdk2.Attributes.String('Testenv switch trigger for new resource switch sequence')
    ttl = DEFAULT_TTL


class ANTIADBLOCK_PERFORMANCE_DUMP(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = 1


class ANTIADBLOCK_SHOOT_RAW_STATS(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_NGINX_ACCESS_LOG(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_NGINX_ERROR_LOG(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_CRYPROX_LOG(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_CRYPROX_END2END_LOG(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_CRYPROX_REGEX_STAT(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_PERFORMANCE_DIFF(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_FUNC_DIFF(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class ANTIADBLOCK_CALLGRIND_STATS(sdk2.resource.AbstractResource):
    auto_backup = True
    ttl = DEFAULT_TTL


class AntiadblockCryproxPackage(YaPackageResource):
    """Cryprox package for Sandbox"""
    ttl = 28  # days
    releasers = ['ANTIADBLOCK']
    testenv_switch_trigger = sdk2.Attributes.String('Testenv switch trigger for new resource switch sequence')


class AntiadblockConfigsStubServer(sdk2.Resource):
    """Configs cache server for cryprox in Sandbox"""
    ttl = 28  # days
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ['ANTIADBLOCK']
