from sandbox import sdk2

from sandbox.projects.yabs.qa.tasks.BuildAmmoAndStubsFromYT import BuildAmmoAndStubsFromYT
from sandbox.projects.antiadblock.qa.resource_types import ANTIADBLOCK_DOLBILKA_PLAN, ANTIADBLOCK_CACHE_DAEMON_STUB_DATA, ANTIADBLOCK_REQUEST_LOG_GZ


class AntiadblockBuildAmmoAndStubsFromYT(BuildAmmoAndStubsFromYT):

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 32 * 1024
        disk_space = 40960

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(BuildAmmoAndStubsFromYT.Parameters):
        description = "Generate cryprox ammo and stubs from YT tables with compatible format"
        max_restarts = 1
        # output resource types
        dolbilka_plan_resource_type = sdk2.parameters.String("Resource type for dolbilka_plan", default=ANTIADBLOCK_DOLBILKA_PLAN.name)
        request_log_gz_resource_type = sdk2.parameters.String("Resource type for request_log_gz", default=ANTIADBLOCK_REQUEST_LOG_GZ.name)
        cache_daemon_stub_resource_type = sdk2.parameters.String("Resource type for cache_daemon_stub", default=ANTIADBLOCK_CACHE_DAEMON_STUB_DATA.name)

        yt_token_vault_name = sdk2.parameters.String("Vault name to get YT token from", default="ANTIADBLOCK_YT_TOKEN")
        legacy_mode = sdk2.parameters.Bool('Legacy mode', default_value=True)
        with legacy_mode.value[True]:
            key_header = sdk2.parameters.String('Key header for ammo and cachedaemon', default='X-Aab-Requestid')
