from sandbox import sdk2

from sandbox.projects.yabs.qa.ammo_module.dplan.adapters.sandbox import AmmoDplanModuleSandboxAdapter
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.dumper_module.adapters.sandbox import DumperModuleSandboxAdapter

from sandbox.projects.antiadblock.qa.modules.configs_stub_module.adapters.sandbox import ConfigsStubSandboxAdapter
from sandbox.projects.antiadblock.qa.modules.engine_module.adapters.sandbox import EngineSandboxAdapter

from sandbox.projects.antiadblock.qa.utils.constants import SHOOT_CONTAINER_ID, SECOND_PREFIX


class BasePerformanceShootParameters(sdk2.Task.Parameters):
    _container = sdk2.parameters.Container(
        'LXC container for ANTIADBLOCK shoot tests',
        default_value=SHOOT_CONTAINER_ID,
        platform='linux_ubuntu_16.04_xenial',
        required=True,
    )

    with sdk2.parameters.Group('Engine settings') as engine_settings:
        engine_parameters = EngineSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Ammo module settings') as ammo_module_setting:
        ammo_parameters = AmmoDplanModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
        dolbilo_parameters = DolbiloModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Dumper module settings') as dumper_module_settings:
        dumper_parameters = DumperModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Output:
        result_stats = sdk2.parameters.JSON('Output processed stats', default={})
        output_resources = sdk2.parameters.JSON('Output resources', default={})


class BaseDiffShootParameters(sdk2.Task.Parameters):
    _container = sdk2.parameters.Container(
        'LXC container for ANTIADBLOCK shoot tests',
        default_value=SHOOT_CONTAINER_ID,
        platform='linux_ubuntu_16.04_xenial',
        required=True,
    )

    with sdk2.parameters.Group('Warmup settings') as warmup_settings:
        warmup_rps = sdk2.parameters.Integer('Warmup RPS', default_value=50, required=True)
        warmup_time = sdk2.parameters.Integer('Warmup time in seconds', default_value=60, required=True)

    with sdk2.parameters.Group('Ammo module settings') as ammo_module_setting:
        ammo_parameters = AmmoDplanModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
        dolbilo_parameters = DolbiloModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Dumper module settings') as dumper_module_settings:
        dumper_parameters = DumperModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('First engine settings') as first_engine_settings:
        first_engine_parameters = EngineSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Second engine settings') as second_engine_settings:
        second_engine_parameters = EngineSandboxAdapter.get_init_parameters_class(prefix=SECOND_PREFIX)()

    with sdk2.parameters.Group('Configs stub settings') as configs_stub_settings:
        configs_stub_parameters = ConfigsStubSandboxAdapter.get_init_parameters_class()()


class BaseFuncDiffShootParameters(sdk2.Task.Parameters):
    _container = sdk2.parameters.Container(
        'LXC container for ANTIADBLOCK shoot tests',
        default_value=SHOOT_CONTAINER_ID,
        platform='linux_ubuntu_16.04_xenial',
        required=True,
    )

    with sdk2.parameters.Group('Ammo module settings') as ammo_module_setting:
        ammo_parameters = AmmoDplanModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
        dolbilo_parameters = DolbiloModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('First engine settings') as first_engine_settings:
        first_engine_parameters = EngineSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Second engine settings') as second_engine_settings:
        second_engine_parameters = EngineSandboxAdapter.get_init_parameters_class(prefix=SECOND_PREFIX)()

    with sdk2.parameters.Group('Configs stub settings') as configs_stub_settings:
        configs_stub_parameters = ConfigsStubSandboxAdapter.get_init_parameters_class()()


class BaseProfilingShootParameters(sdk2.Task.Parameters):
    _container = sdk2.parameters.Container(
        'LXC container for ANTIADBLOCK shoot tests',
        default_value=SHOOT_CONTAINER_ID,
        platform='linux_ubuntu_16.04_xenial',
        required=True,
    )

    with sdk2.parameters.Group('Warmup settings') as warmup_settings:
        warmup_rps = sdk2.parameters.Integer('Warmup RPS', default_value=50, required=True)
        warmup_time = sdk2.parameters.Integer('Warmup time in seconds', default_value=60, required=True)

    with sdk2.parameters.Group('Ammo module settings') as ammo_module_setting:
        ammo_parameters = AmmoDplanModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
        dolbilo_parameters = DolbiloModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Dumper module settings') as dumper_module_settings:
        dumper_parameters = DumperModuleSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Engine settings') as engine_settings:
        engine_parameters = EngineSandboxAdapter.get_init_parameters_class()()

    with sdk2.parameters.Group('Configs stub settings') as configs_stub_settings:
        configs_stub_parameters = ConfigsStubSandboxAdapter.get_init_parameters_class()()
