from enum import IntEnum


class DiffType(IntEnum):
    LATENCY = 0
    CAPACITY = 1
    END2END = 2
    PROFILING = 3


# container ids
SHOOT_CONTAINER_ID = 1515048650
NGINX_BINARY_RESOURCE_ID = 1447199501

# Header
REQUEST_ID_HEADER = 'X-Aab-Requestid'

# Sandbox secrets
CRYPROX_TVM2_SECRET = "CRYPROX_TVM2_SECRET"
ANTIADBLOCK_COOKIEMATCHER_CRYPT_KEYS = "ANTIADBLOCK_COOKIEMATCHER_CRYPT_KEYS"

# filename template
FILE_RAW_STATS_TMPL = "raw_stats_{}.txt"
FILE_NGINX_ACCESS_LOG_TMPL = "nginx_access_log_{}.log"
FILE_NGINX_ERROR_LOG_TMPL = "nginx_error_log_{}.log"
FILE_CRYPROX_LOG_TMPL = "cryprox_log_{}.log"
FILE_CRYPROX_END2END_LOG_TMPL = "cryprox_end2end_{}.log"
FILE_CRYPROX_REGEX_STAT_TMPL = "regex_stat_{}.log"

# filename for callgrind
CALLGRIND_FILENAME = '/logs/cryprox/run.callgrind'


# report keys
REPORT_KEYS = ('all', 'cryprox', 'bamboozled', 'accelredirect')
REPORT_KEYS_STAT = ('ALL', 'CRYPROX', 'ACCELREDIRECT')

# prefix for second engine parameters
SECOND_PREFIX = '_2'

STAT_REPORT_PATH = 'AntiAdblock/cryprox_sandbox_tests'
PERCENTILES = (50, 90, 95, 99, 99.9)
