import os
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.types.misc import DnsType
import sandbox.common.types.client as ctc
import sandbox.common.types.resource as ctr

from sandbox.projects.antiadblock.utils.yt_helpers import get_available_yt_clusters
from sandbox.projects.antiadblock.utils import ROBOT_ANTIADB_TOKENS_YAV_ID


class AntiadblockBinResource(sdk2.Resource):
    """
    Base Antiadblock Bin Execute Class
    """
    releasable = True
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    release_subscribers = ["ANTIADBLOCK"]


# antiadblock/tasks/money_monitoring binary
class AntiadblockMoneyMonitoringBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/detect_verification binary
class AntiadblockDetectVerificationBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/bs_dsp_money binary
class AntiadblockBsDspMoneyBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/morda_awaps binary
class AntiadblockMordaAwapsBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/money_vh binary
class AntiadblockMoneyVhBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/money_inapp binary
class AntiadblockMoneyInappBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/morda_awaps_by_templates binary
class AntiadblockMordaAwapsTemplatesBin(AntiadblockBinResource):
    pass


# antiadblock/partner/nginx/files/aab_cookie_validator.lua
class AntiadblockPartnerNginxLuaPlugin(AntiadblockBinResource):
    pass


# antiadblock/tasks/turbo_money binary
class AntiadblockTurboMoneyBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/games_money binary
class AntiadblockGamesMoneyBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/experiments/bypass binary
class AntiadblockExperimentBypassBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/experiments/forcecry binary
class AntiadblockExperimentForcecryBin(AntiadblockBinResource):
    pass


# antiadblock/analytics_service/service binary
class AntiadblockAnalyticsServiceBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/support_money_loss binary
class AntiadblockSupportMoneyLossBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/monitoring_update binary
class AntiadblockMonitoringAutoupdateBin(AntiadblockBinResource):
    pass


class AntiadblockBypassUids(AntiadblockBinResource):
    pass


# antiadblock/tasks/update_bypass_uids binary
class AntiadblockUpdateBypassUidsBin(AntiadblockBinResource):
    pass


class AntiadblockPcodeVersionsDashboardBin(AntiadblockBinResource):
    pass


# antiadblock/argus/result_agregate_task binary
class ArgusResultAgregateTaskBin(AntiadblockBinResource):
    pass


# antiadblock/argus/logs_agregate_task binary
class ArgusLogsAgregateTaskBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/autoredirect_data
class AntiadblockAutoredirectDataBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/startrek_duty
class AntiadblockStartrekDutyBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/morda_aab_cookies binary
class AntiadblockMordaCookieOfTheDayBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/gpdr_aab_cookies binary
class AntiadblockGDPRCookiesBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/slb_pinger binary
class AntiadblockSlaPingerBin(AntiadblockBinResource):
    pass


# TODO: remove (temporary resourse for ticket ANTIADB-2292)
class AntiadblockNginxTemplate(AntiadblockBinResource):
    pass


# TODO: remove (temporary resourse for ticket ANTIADB-2292)
class AntiadblockCryproxTemplate(AntiadblockBinResource):
    pass


# TODO: remove (temporary resourse for ticket ANTIADB-2292)
class AntiadblockLaunchFilebeat(AntiadblockBinResource):
    pass

# TODO: remove (temporary resourse for ticket ANTIADB-2292)
class AntiadblockNginxFilebeatConfig(AntiadblockBinResource):
    pass

# TODO: remove (temporary resourse for ticket ANTIADB-2292)
class AntiadblockCryproxFilebeatConfig(AntiadblockBinResource):
    pass

# antiadblock/tasks/update_lj_custom_domains binary
class AntiadblockUpdateLjCustomDomainsBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/change_current_cookie binary
class AntiadblockChangeCurrentCookieBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/generate_ammo_stub_table binary
class AntiadblockGenerateAmmoStubTableBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/monitoring_stats binary
class AntiadblockMonitoringStatsBin(AntiadblockBinResource):
    pass


# antiadblock/tasks/monitoring_stats binary
class AntiadblockBypassUidsStatBin(AntiadblockBinResource):
    pass


# https://st.yandex-team.ru/ANTIADB-2783
class AntiadblockCryproxInternalExperimentConfig(AntiadblockBinResource):
    ttl = 365


RESOURCE_CLASSES = [
    ArgusResultAgregateTaskBin,
    ArgusLogsAgregateTaskBin,
    AntiadblockMoneyMonitoringBin,
    AntiadblockDetectVerificationBin,
    AntiadblockBsDspMoneyBin,
    AntiadblockMordaAwapsBin,
    AntiadblockMoneyVhBin,
    AntiadblockMoneyInappBin,
    AntiadblockMordaAwapsTemplatesBin,
    AntiadblockTurboMoneyBin,
    AntiadblockGamesMoneyBin,
    AntiadblockExperimentBypassBin,
    AntiadblockExperimentForcecryBin,
    AntiadblockAnalyticsServiceBin,
    AntiadblockSupportMoneyLossBin,
    AntiadblockMonitoringAutoupdateBin,
    AntiadblockUpdateBypassUidsBin,
    AntiadblockPcodeVersionsDashboardBin,
    AntiadblockAutoredirectDataBin,
    AntiadblockStartrekDutyBin,
    AntiadblockMordaCookieOfTheDayBin,
    AntiadblockGDPRCookiesBin,
    AntiadblockSlaPingerBin,
    AntiadblockUpdateLjCustomDomainsBin,
    AntiadblockChangeCurrentCookieBin,
    AntiadblockGenerateAmmoStubTableBin,
    AntiadblockMonitoringStatsBin,
    AntiadblockBypassUidsStatBin,
]


class AntiadblockRunBinary(sdk2.Task):
    """Runs any binary from SB resource"""

    class Requirements(sdk2.Requirements):
        cores = 1
        client_tags = ctc.Tag.LINUX_XENIAL
        dns = DnsType.DNS64  # for external interactions

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Task.Parameters):
        binary = sdk2.parameters.LastReleasedResource(
            'Resource type to run',
            state=(ctr.State.READY,),
            required=False,
            attrs=dict(released='stable'),
        )
        binary_class = sdk2.parameters.String(
            'binary class to run', required=False,
            choices=[(c.__name__,) * 2 for c in RESOURCE_CLASSES]
        )
        env_vars = sdk2.parameters.String('Optional environment variables (expecting "var1=val1;var2=val2")', required=False)

    def on_execute(self):
        if self.Parameters.binary_class:
            resource_class = None
            for resource_class in RESOURCE_CLASSES:
                if resource_class.__name__ == self.Parameters.binary_class:
                    break
            binary_id = sdk2.Resource.find(
                resource_type=resource_class,
                state=ctr.State.READY
            ).limit(1).first()
            bin_res = sdk2.ResourceData(binary_id)
        elif self.Parameters.binary:
            bin_res = sdk2.ResourceData(self.Parameters.binary)
        else:
            raise Exception('Binary Resource not selected!')

        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()
        env = os.environ.copy()
        env['YT_TOKEN'] = yav_secrets["ANTIADBLOCK_YT_TOKEN"]
        env['STAT_TOKEN'] = yav_secrets["ANTIADBLOCK_STAT_TOKEN"]
        env['CHARTS_TOKEN'] = yav_secrets["ANTIADBLOCK_CHARTS_TOKEN"]
        env['S3_SECRET_KEY'] = yav_secrets['ANTIADBLOCK_S3_SECRET_KEY']
        env['S3_KEY_ID'] = yav_secrets['ANTIADBLOCK_S3_KEY_ID']
        env['CONFIGS_API_HOST'] = 'api.aabadmin.yandex.ru'
        env['CONFIGSAPI_TVM_ID'] = '2000629'
        env['TVM_ID'] = '2002631'
        env['TVM_SECRET'] = yav_secrets['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET']
        env['SOLOMON_TOKEN'] = yav_secrets['ANTIADBLOCK_SOLOMON_TOKEN']
        env['STARTREK_TOKEN'] = yav_secrets['ANTIADBLOCK_ST_TOKEN']
        env['JUGGLER_TOKEN'] = yav_secrets['ANTIADBLOCK_JUGGLER_OAUTH_TOKEN']
        env['WIKI_TOKEN'] = yav_secrets['ANTIADBLOCK_WIKI_API_OAUTH_TOKEN']
        env['SB_TOKEN'] = yav_secrets['ANTIADBLOCK_SANDBOX_TOKEN']
        env['ABC_TOKEN'] = yav_secrets['ANTIADBLOCK_ABC_TOKEN']

        # get available yt clusters
        env['AVAILABLE_YT_CLUSTERS'] = get_available_yt_clusters()
        logging.info('AVAILABLE YT CLUSTERS: {}'.format(env['AVAILABLE_YT_CLUSTERS']))

        if self.Parameters.env_vars:
            for kv in self.Parameters.env_vars.strip().strip(';').split(';'):
                key, value = kv.split('=')
                env[key.strip()] = value.strip()

        cmd = [str(bin_res.path)]
        with sdk2.helpers.ProcessLog(self, logger="run_task_log") as log:
            sp.check_call(cmd, stdout=log.stdout, stderr=log.stderr, env=env)
