import json

from sandbox import sdk2


class AntiadblockAvailableYtClustersResource(sdk2.Resource):
    any_arch = True
    auto_backup = True
    group = 'ANTIADBLOCK'
    releasers = ['ANTIADBLOCK']
    ttl = 30


class AntiadblockSaveAvailableYtClusters(sdk2.Task):
    name = 'ANTIADBLOCK_SAVE_AVAILABLE_YT_CLUSTERS'

    class Parameters(sdk2.Task.Parameters):
        description = "Antiadblock save available Yt clusters task"

        with sdk2.parameters.Group('YT cluster settings') as cluster_settings:
            arnold_available = sdk2.parameters.Bool('Arnold available', default=True)
            hahn_available = sdk2.parameters.Bool('Hahn available', default=True)

    def on_execute(self):
        with open("all_clusters.txt", mode='w') as fout:
            all_clusters = []
            if self.Parameters.arnold_available:
                all_clusters.append('arnold')
            if self.Parameters.hahn_available:
                all_clusters.append('hahn')
            json.dump(all_clusters, fout)

        sdk2.ResourceData(AntiadblockAvailableYtClustersResource(
            self, "Output file", "all_clusters.txt"
        )).ready()
