import os

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common import binary_task

from solomon import update_alert
from juggler import update_aggregate, ROBOT_ANTIADB_TOKENS_YAV_ID


class AabZfpMonitoringAutoupdate(binary_task.LastBinaryTaskRelease, sdk2.Task):
    name = "AAB_ZFP_MONITORING_AUTOUPDATE"

    class Parameters(sdk2.Task.Parameters):
        alerts = sdk2.parameters.String('IDs of alerts to update', default_value="")
        juggler_aggregates = sdk2.parameters.String('Juggler hosts to update', default_value="")
        use_solomon_prestable = sdk2.parameters.Bool('Use solomon-prestable', default_value=False)
        ext_params = binary_task.binary_release_parameters(stable=True)

    @property
    def binary_executor_query(self):
        return {
            "attrs": {"task_type": AabZfpMonitoringAutoupdate.name, "released": self.Parameters.binary_executor_release_type},
            "state": [ctr.State.READY]
        }

    def on_execute(self):

        os.chdir(str(self.path()))
        yav_secrets = sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()

        if self.Parameters.alerts:
            Arcadia.export(Arcadia.trunk_url('/antiadblock/zfp/solomon_alerts'), str(self.path('alerts')))
            solomon_token = yav_secrets['ANTIADBLOCK_SOLOMON_TOKEN']
            for alert_id in self.Parameters.alerts.split(','):
                update_alert(alert_id.strip(), str(self.path('alerts')), solomon_token, use_prestable=self.Parameters.use_solomon_prestable)

        if self.Parameters.juggler_aggregates and not self.Parameters.use_solomon_prestable:
            Arcadia.export(Arcadia.trunk_url('/antiadblock/zfp/juggler_aggregates'), str(self.path('aggregates')))
            juggler_token = yav_secrets['ANTIADBLOCK_JUGGLER_OAUTH_TOKEN']
            for aggregate_host in self.Parameters.juggler_aggregates.split(','):
                update_aggregate(aggregate_host.strip(), str(self.path('aggregates')), juggler_token)
