import os
import logging
from copy import deepcopy
from collections import defaultdict

import yaml

from sandbox import sdk2

MULTIPLY_BY_SERVICE_ID_MARK = '*'
INHERIT_SERVICE_ID_MARK = '#'

ROBOT_ANTIADB_TOKENS_YAV_ID = "sec-01crfs4yjd29hardw658g1qk84"


def create_check_from_params(aggregate_params, service_ids, notification_map):
    from juggler_sdk import Check, Child, FlapOptions
    params = deepcopy(aggregate_params)
    children_params = params['children']
    notifications = params['notifications']
    unreach_checks = params.get('aggregator_kwargs', {}).get('unreach_checks')
    _service_id = params['service'].replace('_call', '')

    children = []
    for child in children_params:
        _service_id = params['service'].replace('_call', '')
        raw_event_service = child['child'].setdefault('service', _service_id)
        if raw_event_service == MULTIPLY_BY_SERVICE_ID_MARK:
            children += [Child(child['child']['host'], service_id) for service_id in service_ids]
            continue
        elif INHERIT_SERVICE_ID_MARK in raw_event_service:
            raw_event_service = raw_event_service.replace(INHERIT_SERVICE_ID_MARK, _service_id)
        children.append(Child(child['child']['host'], raw_event_service))
    if unreach_checks is not None:
        for i in range(len(unreach_checks)):
            if INHERIT_SERVICE_ID_MARK in unreach_checks[i]:
                unreach_checks[i] = unreach_checks[i].replace(INHERIT_SERVICE_ID_MARK, _service_id)
        params['aggregator_kwargs'].update({
            'unreach_checks': unreach_checks
        })

    params.update({
        'children': children,
        'notifications': [notification_map[notification] for notification in notifications]
    })
    format_description = params.pop('format_description', None)

    if format_description is not None:
        format_description['service_id'] = params['service']
        if 'crit_desc' in params['aggregator_kwargs']:
            params['aggregator_kwargs']['crit_desc'] = params['aggregator_kwargs']['crit_desc'].format(**format_description)
        if 'pronounce' in params:
            params['pronounce'] = params['pronounce'].format(**format_description).replace('_call', '').strip()

    if 'flaps_config' in params:
        params.update({'flaps_config': FlapOptions(**params['flaps_config'])})
    return Check(**params)


def update_aggregate(host, path, juggler_token):
    from antiadblock.tasks.tools.const import VALUABLE_SERVICES
    from antiadblock.tasks.tools.configs_api import get_configs
    from antiadblock.tasks.tools.juggler import create_aggregate_checks
    from antiadblock.tasks.tools.notifications import TELEGRAM, DAY_PHONE, NIGHT_PHONE

    NOTIFICATION_MAP = {
        'TELEGRAM': TELEGRAM,
        'DAY_PHONE': DAY_PHONE,
        'NIGHT_PHONE': NIGHT_PHONE
    }
    AGGREGATES = defaultdict(list)
    logging.info("Update host: {}".format(host))

    service_ids = get_configs(2002631, sdk2.yav.Secret(ROBOT_ANTIADB_TOKENS_YAV_ID).data()['ANTIADBLOCK_SANDBOX_MONITORING_TVM_SECRET'], 2000629, monitorings_enabled=True)
    with open(os.path.join(path, host, 'aggregate.yaml'), "r") as stream:
        aggregate_config = yaml.safe_load(stream)
    for aggregate_id, aggregate_params in aggregate_config.items():
        juggler_host, juggler_service = aggregate_id.split(':')
        aggregate_params.update({
            'host': juggler_host,
            'service': juggler_service
        })
        service_template = aggregate_params['service']
        if MULTIPLY_BY_SERVICE_ID_MARK in juggler_service:
            service_ids_to_create = VALUABLE_SERVICES if 'call' in juggler_service else service_ids
            for service_id in service_ids_to_create:
                aggregate_params['service'] = service_template.replace(MULTIPLY_BY_SERVICE_ID_MARK, service_id)
                AGGREGATES[aggregate_params['mark']].append(create_check_from_params(aggregate_params, service_ids, NOTIFICATION_MAP))
        else:
            AGGREGATES[aggregate_params['mark']].append(create_check_from_params(aggregate_params, service_ids, NOTIFICATION_MAP))

    for mark, checks in AGGREGATES.items():
        create_aggregate_checks(checks, mark, juggler_token=juggler_token)

    logging.info("Update host success: {}".format(host))
