# coding: utf-8

from __future__ import absolute_import

from sandbox import sdk2


class ANTIVIRUS_BLACK_LIST(sdk2.resource.AbstractResource):  # noqa - class naming
    """Black hosts list for antivirus project.

    https://st.yandex-team.ru/ANTIVIR-4643
    """

    auto_backup = True


class ANTIVIRUS_SMS_FRAUD_BLACK_LIST(sdk2.resource.AbstractResource):  # noqa - class naming
    """Black list for sms fraud (ANTIVIR-5356)"""

    auto_backup = True


class ANTIVIRUS_REFERER_ENCRYPTION_KEYS(sdk2.resource.AbstractResource):  # noqa - class naming
    """Serp referer encryption data (ANTIVIR-5366)"""

    auto_backup = True


class SAFEBROWSING_CLIENTREPORT_DOWNLOAD_CODE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Handler for clientreport/download safebrowsing api url
    """

    auto_backup = True


class SAFEBROWSING_API_CERTIFICATE_LISTS(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Certificate signatures lists used in Safebrowsing API
    """

    auto_backup = True


class SAFEBROWSING_API_DOWNLOAD_HOST_LISTS(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Hosts black/white lists used in Safebrowsing API (ANTIVIR-5048)
    """

    auto_backup = True


class SAFEBROWSING_API_VIRUSTOTAL_FILE_SCANS(sdk2.resource.AbstractResource):  # noqa - naming
    """Prepared VirusTotal file scan reports database used in Safebrowsing API
    clientreport/download handler (https://st.yandex-team.ru/ANTIVIR-4541)
    """

    auto_backup = True


class SAFEBROWSING_API_FILE_HASH_LISTS(sdk2.resource.AbstractResource):  # noqa - naming
    """
    File hash sum black/white lists used in Safebrowsing API (ANTIVIR-5048)
    """

    auto_backup = True


class SAFEBROWSING_CLIENTREPORT_PHISHING_CODE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Handler for clientreport/phishing safebrowsing api url
    """

    auto_backup = True


class SAFEBROWSING_API_CSD_DATA(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Required data for client-side detection:
    - client model for phishing detection
    """

    auto_backup = True
    releasable = True


class SAFEBROWSING_API_PHISHING_HOST_LISTS(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Hosts black/white lists used in Safebrowsing API backend for client-side
    phishing detection (ANTIVIR-5609)
    """

    auto_backup = True
    releasable = True


class SAFEBROWSING_API_DATABASE(sdk2.resource.AbstractResource):
    """
    Safebrowsing API virus data: SBA list info, fullhash tries, SBA chunk files
    """

    auto_backup = True
    releasable = True


class ANTIVIRUS_PYDANET_TEST_DATA(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Test data for antivir.pydanet
    """

    auto_backup = True


class ANTIMALWARE_RTC_QEMU_IMAGES(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Virtual machine images used in RTC-Qemu
    """

    auto_backup = True


class ANTIMALWARE_TEST_DATA(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Data used in tests in antimalware project
    """

    auto_backup = True


class ANTISHOCK_IMAGES_DATASET(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Dataset for training Danet Model
    """

    auto_backup = True


class ANTISHOCK_IMAGES_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Danet Model (config.cfg + model)
    """

    auto_backup = True


class ANTISHOCK_IMG_TRASH_TF_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    TensorFlow Model for trash images classification (graph.pb file)
    """

    auto_backup = True


class ANTISHOCK_TEXT_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    VW Model (model)
    """

    auto_backup = True


class ANTISHOCK_ADV_TEXT_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    VW Adds model (model)
    """

    auto_backup = True


class ANTISHOCK_ADV_IMAGES_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Danet Model for adv classificaiton (config.cfg + model)
    """

    auto_backup = True


class ANTISHOCK_IMG_ADV_TF_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    TensorFlow model for adv classification (graph.pb file)
    """

    auto_backup = True


class ANTISHOCK_ADV_IMAGES_DATASET(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Dataset for training danet adv model
    """

    auto_backup = True


class ANTIVIRUS_TEASERS_URL_MODEL(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Matrixnet model
    """

    auto_backup = True


class ANTIVIRUS_TEASERS_FML_FORMULA(sdk2.resource.AbstractResource):  # noqa - naming
    """
    FML formula for teasers
    """

    auto_backup = True


class ANTIMALWARE_DIRECTCHECKER_CONFIGS(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Dynamic directchecker configuration
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_THREAT_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Threat masks trie for directchecker
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_ROBOT_DETECTIONS_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Masks trie from directchecker robot detections
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_PORN_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Porn masks trie for directchecker
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_BIDS_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Bids trie for directchecker
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_CIDS_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Cids trie for directchecker
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_DIRECTCHECKER_UIDS_TRIE(sdk2.resource.AbstractResource):  # noqa - naming
    """
    Uids trie for directchecker
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_SOPHOS_SDK(sdk2.resource.AbstractResource):  # noqa: N801
    """
    SAV Interface Developer Toolkit

    Here are headers only
    Download URL:
        https://downloads.sophos.com/sophos/products/
        full/OEM/SAVi/current/sdk/savidtk.tar.gz
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_SOPHOS_ENGINE(sdk2.resource.AbstractResource):  # noqa: N801
    """
    SAV Interface library

    Here is shared library with full functionality of Sophos anti-malware
    engine
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_SOPHOS_TEST_SUITE(sdk2.resource.AbstractResource):  # noqa: N801
    """
    SAVI (Sophos Anti-Virus Interface) Test Suite
    """

    auto_backup = True


class ANTIMALWARE_SOPHOS_VIRUS_DATA(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Virus data library for Sophos anti-malware engine
    """
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_SOPHOS_THREAT_IDE(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Thread identity files for Sophos anti-malware engine
    """
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_UDF_LIBRARY(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Shared library for udf
    """


class ANTIMALWARE_AREAS_LISTS(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Areas lists for Antivirus project
    """

    releasable = True


class ANTIMALWARE_METRICID_DIRECT_BLACKLIST(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Blacklist for avdr-metric-id leprosus detector
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_ANALYTICS_MANUAL_BLACKLIST(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Manual configs from antimalware analytics folder
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_ANALYTICS_MANUAL_DIRECT_FRAUD_AFFILIATE(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Manual configs from antimalware analytics folder
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_ANALYTICS_MANUAL_SMS_FRAUD(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Manual configs from antimalware analytics folder
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITROBOT_DETECTORS_CONFIGS(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Antimalware hitrobot detectors configs
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HOSTS_GROUPS_CONFIG(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Antimalware hosts groups configs
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_JURY_DETECTORS_CONFIGS(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Antimalware content check detectors configs
    """

    auto_backup = True
    releasable = True
    releasers = ["HITROBOT", "greygrey", "i-osipov", "anechiporuk", "robot-antivirus-ci"]
    release_subscribers = ["greygrey"]


class ANTIMALWARE_DIRECT_CONTENT_RULES(sdk2.resource.AbstractResource):  # noqa: N801
    """
    Content rules for direct detectors
    """

    auto_backup = True
    releasable = True


class ANTIMALWARE_HITROBOT_BOX(sdk2.Resource):  # noqa N801
    """
    Hitrobot host box layer
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk", "robot-antivirus-ci"]


class ANTIMALWARE_HITROBOT_IMAGE(sdk2.Resource):  # noqa N801
    """
    Hitrobot Win image
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk"]


class ANTIMALWARE_HITROBOT_LINUX_IMAGE(sdk2.Resource):  # noqa N801
    """
    Hitrobot Linux image
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk"]


class ANTIMALWARE_HITROMIUM(sdk2.Resource):  # noqa N801
    """
    Hitromium for Linux
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk"]


class ANTIMALWARE_HITROMIUM_MSI(sdk2.Resource):  # noqa N801
    """
    Hitrobot installer
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk"]


class ANTIMALWARE_HITROMIUM_BUILD_RESULTS(sdk2.Resource):  # noqa N801
    """
    Hitromium build results
    """

    releasable = True
    releasers = ["HITROBOT", "anechiporuk"]


class ANTIMALWARE_HITROMIUM_KERNEL(sdk2.Resource):  # noqa N801
    """
    Hitromium kernel for Jupyter
    """

    releasable = True


class ANTIMALWARE_HITROBOT_TURBOAPPS(sdk2.Resource):
    """
    Turboapps pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITROBOT_LEPROSUS(sdk2.Resource):
    """
    Leprosus pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITROBOT_ZEN(sdk2.Resource):
    """
    Zen pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_ZEN_MODELS(sdk2.Resource):
    """
    Models for zen pipeline
    """

    releasable = True
    releasers = ["HITROBOT", 'greygrey', 'i-osipov']


class ANTIMALWARE_HITROBOT_JURY(sdk2.Resource):
    """
    Jury pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITROBOT_DIRECT(sdk2.Resource):
    """
    Direct pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITROBOT_HITRENIMALS(sdk2.Resource):
    """
    Direct pipeline
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_HITRENIMALS_GRPC_API(sdk2.Resource):
    """
    Hitrenimals GRPC API service image
    """

    releasable = True


class ANTIMALWARE_HITROBOT_TUNNEL_INFO(sdk2.Resource):
    """
    Tunnel info service image
    """

    releasable = True


class ANTIMALWARE_TREX_SERVICE(sdk2.Resource):
    """
    TREX service image
    """

    releasable = True


class ANTIMALWARE_COORDINATOR_SERVICE(sdk2.Resource):
    """
    Coordinator service image
    """

    releasable = True


class ANTIMALWARE_QUEUE(sdk2.Resource):
    """
    Antimalware Queue service
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_DIRECTCHECKER_ENGINE(sdk2.Resource):
    """
    Antimalware Directchecker engine
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_DIRECTCHECKER_SERVICE(sdk2.Resource):
    """
    Antimalware Directchecker service
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_BANNED_CAMPAIGNS(sdk2.Resource):
    """
    Antimalware Directchecker Banned Campaigns
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_BANNER_INSPECTION(sdk2.Resource):
    """
    Antimalware Directchecker Banner Inspection
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_CORE(sdk2.Resource):
    """
    Antimalware Directchecker Core
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_FRESH_URLS_QUEUE(sdk2.Resource):
    """
    Antimalware Directchecker Fresh Urls Queue
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_INCOMING_BANNERS(sdk2.Resource):
    """
    Antimalware Directchecker Incoming Banners
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_KEYWORD_BAN(sdk2.Resource):
    """
    Antimalware Directchecker Keyword Ban
    """

    releasable = True


class ANTIMALWARE_DIRECTCHECKER_METRICS(sdk2.Resource):
    """
    Antimalware Directchecker Metrics
    """

    releasable = True


class ANTIMALWARE_INFECTED_DATABASE_CONTROLLER(sdk2.Resource):
    """
    Antimalware Infected database controller
    """

    releasable = True
    releasers = ["HITROBOT"]


class ANTIMALWARE_INFRED(sdk2.Resource):
    """
    Antimalware Infred
    """

    releasable = True


class ANTIMALWARE_SBAPI(sdk2.Resource):
    """
    Antimalware sbapi layer for deployment to instances
    """

    releasable = True


class ANTIMALWARE_KIDS_MODE_SERVER(sdk2.Resource):
    """
    Antimalware Kids Mode server
    """

    releasable = True


class ANTIMALWARE_CLIENTREPORT_DOWNLOAD(sdk2.Resource):
    """
    Antimalware sbapi clientreport-download layer for deployment to instances
    """

    releasable = True


class ANTIMALWARE_CLIENTREPORT_PHISHING(sdk2.Resource):
    """
    Antimalware sbapi clientreport-phishing layer for deployment to instances
    """

    releasable = True


class ANTIMALWARE_ANTISCANDAL_MASKS(sdk2.Resource):
    """
    Antimalware antiscandal masks
    """

    releasable = True


class ANTIMALWARE_HITROBOT_TASKARBITER(sdk2.Resource):
    """
    Antimalware Hitrobot Task Arbiter
    """

    releasable = True


class ANTIMALWARE_HITROBOT_TASKARBITER_LOADTESTING_GUN(sdk2.Resource):
    """
    Antimalware Hitrobot Task Arbiter loadtesting gun
    """

    releasable = True


class ANTIMALWARE_HITROBOT_TASKARBITER_LOADTESTING_PUSH_ASSESSMENT(sdk2.Resource):
    """
    Antimalware Hitrobot Task Arbiter loadtesting push assessment
    """

    releasable = True


class ANTIMALWARE_CLIENTS_CONFIG(sdk2.Resource):
    """
    Antimalware Clients Config
    """

    releasable = True


class TelluriumBuild(sdk2.Resource):
    """
    Tellurium build
    """

    releasers = ["cepera"]
    releasable = True


class ANTIMALWARE_HITROBOT_PROXY(sdk2.Resource):
    """
    Antimalware Hitrobot HTTP(S) MITM proxy
    """

    releasable = True


class ANTIMALWARE_HITROBOT_PROXY_PROVIDER(sdk2.Resource):
    """
    Antimalware Hitrobot Proxy Provider
    """

    releasable = True


class ANTIMALWARE_PUBLIC_SUFFIX_CONFIG(sdk2.Resource):
    """
    Antimalware mozilla public suffix list config
    """

    releasable = True
