import json

from sandbox import sdk2, common
import sandbox.common.types.task as ctt

from sandbox.projects.antirobot.ValidationServiceJsonFile import AntirobotValidationServiceJsonFile
from sandbox.projects.antirobot.MergeJsonConfigFiles import SERVICES, FindLastCorrectResourse


def GetLastServiceConfig(service):
    correctServiceConfigResource = FindLastCorrectResourse(service)
    assert correctServiceConfigResource is not None, 'There is no correct ANTIROBOT_SERVICE_JSON_FILE_RESOURCE ' \
                                                     'resource with attribute service = %s' % service

    with open(str(sdk2.ResourceData(correctServiceConfigResource).path), 'r') as jsonFile:
        return json.load(jsonFile)


class AntirobotAddParameterServiceConfig(sdk2.Task):
    """Task to add parameters into every section in service config"""

    class Parameters(sdk2.Task.Parameters):
        rest_parameters = sdk2.parameters.JSON('Rest parameters', required=True)
        dont_validate = sdk2.parameters.Bool('Do not validate (only for superadmins)', required=True)

    def on_execute(self):
        with self.memoize_stage.create_children:
            rest_parameters = self.Parameters.rest_parameters
            dont_validate = self.Parameters.dont_validate
            assert isinstance(rest_parameters, dict), "Json file should contain map"

            subtasks = []
            for service_name in SERVICES:
                json_config = GetLastServiceConfig(service_name)
                json_config.update(rest_parameters)

                task = AntirobotValidationServiceJsonFile(self,
                                                          description="Child of AntirobotAddParameterServiceConfig task {}".format(self.id),
                                                          service_name=service_name,
                                                          json_config='json_strings',
                                                          json_string=json_config,
                                                          create_resource=True,
                                                          dont_validate=dont_validate
                                                          )
                subtasks.append(task.enqueue().id)
            raise sdk2.WaitTask(subtasks, set(common.utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)), wait_all=True)

        failed_subtasks = [t for t in self.find().limit(0) if t.status in ctt.Status.Group.SCHEDULER_FAILURE]
        if not failed_subtasks:
            return

        raise common.errors.TaskError(
            '\n'.join(['Subtask {} ({}) was finished with the status of {}'.format(t.type, t.id, t.status) for t in
                       failed_subtasks])
        )
